/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemSolidifiedExperience;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class TileEntityXPSolidifier
extends TileEntityInventoryBase
implements IButtonReactor {
    private static final int[] XP_MAP = new int[256];
    private final int[] buttonAmounts = new int[]{1, 5, 10, 20, 30, 40, 50, 64, -999};
    public int amount;
    private int lastAmount;
    private int singlePointAmount;

    public TileEntityXPSolidifier() {
        super(2, "xpSolidifier");
    }

    public static int getExperienceForLevel(int level) {
        if (level >= 0 && level < XP_MAP.length) {
            return XP_MAP[level];
        }
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        return TileEntityXPSolidifier.getExperienceForLevelImpl(level);
    }

    private static int getExperienceForLevelImpl(int level) {
        int res = 0;
        for (int i = 0; i < level; ++i) {
            if ((res += TileEntityXPSolidifier.getXpBarCapacity(i)) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return res;
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getLevelForExperience(int experience) {
        int i;
        for (i = 0; i < XP_MAP.length; ++i) {
            if (XP_MAP[i] <= experience) continue;
            return i - 1;
        }
        i = XP_MAP.length;
        while (TileEntityXPSolidifier.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)TileEntityXPSolidifier.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, TileEntityXPSolidifier.getPlayerXP(player) + amount);
        player.field_71068_ca = TileEntityXPSolidifier.getLevelForExperience(experience);
        int expForLevel = TileEntityXPSolidifier.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        compound.func_74768_a("Amount", this.amount);
        compound.func_74768_a("SinglePointAmount", this.singlePointAmount);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.amount = compound.func_74762_e("Amount");
        this.singlePointAmount = compound.func_74762_e("SinglePointAmount");
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (this.amount > 0) {
                stack = this.inv.getStackInSlot(0);
                if (stack.func_190926_b()) {
                    int toSet = this.amount > 64 ? 64 : this.amount;
                    this.inv.setStackInSlot(0, new ItemStack(InitItems.itemSolidifiedExperience, toSet));
                    this.amount -= toSet;
                    this.func_70296_d();
                } else if (stack.func_190916_E() < 64) {
                    int needed = 64 - stack.func_190916_E();
                    int toAdd = Math.min(needed, this.amount);
                    stack.func_190917_f(toAdd);
                    this.amount -= toAdd;
                    this.func_70296_d();
                }
            }
            if (!this.isRedstonePowered) {
                int range = 5;
                List orbs = this.field_145850_b.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - range), (double)(this.field_174879_c.func_177956_o() - range), (double)(this.field_174879_c.func_177952_p() - range), (double)(this.field_174879_c.func_177958_n() + 1 + range), (double)(this.field_174879_c.func_177956_o() + 1 + range), (double)(this.field_174879_c.func_177952_p() + 1 + range)));
                if (orbs != null && !orbs.isEmpty()) {
                    for (EntityXPOrb orb : orbs) {
                        if (orb == null || orb.field_70128_L || orb.getEntityData().func_74767_n("actuallyadditionsFromSolidified")) continue;
                        this.singlePointAmount += orb.func_70526_d();
                        orb.func_70106_y();
                        if (this.singlePointAmount < 8) continue;
                        this.amount += this.singlePointAmount / 8;
                        this.singlePointAmount = 0;
                        this.func_70296_d();
                    }
                }
            }
            if (StackUtil.isValid(stack = this.inv.getStackInSlot(1)) && stack.func_77973_b() instanceof ItemSolidifiedExperience) {
                int remainingSpace = MathHelper.func_76125_a((int)(Integer.MAX_VALUE - this.amount), (int)0, (int)stack.func_190916_E());
                if (stack.func_190916_E() >= remainingSpace && remainingSpace != 0) {
                    this.amount += remainingSpace;
                    stack.func_190918_g(remainingSpace);
                    this.func_70296_d();
                }
            }
            if (this.lastAmount != this.amount && this.sendUpdateWithInterval()) {
                this.lastAmount = this.amount;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> slot == 1 && stack.func_77973_b() == InitItems.itemSolidifiedExperience;
    }

    @Override
    public void func_70296_d() {
        if (this.amount < 0) {
            this.amount = Integer.MAX_VALUE;
        }
        super.func_70296_d();
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        int playerXP;
        if (buttonID < this.buttonAmounts.length && (playerXP = TileEntityXPSolidifier.getPlayerXP(player)) > 0) {
            int xp;
            int n = xp = this.buttonAmounts[buttonID] == -999 ? playerXP / 8 : this.buttonAmounts[buttonID];
            if (this.amount < Integer.MAX_VALUE - xp && playerXP >= 8 * xp) {
                TileEntityXPSolidifier.addPlayerXP(player, -(8 * xp));
                if (!this.field_145850_b.field_72995_K) {
                    this.amount += xp;
                }
            }
        }
    }

    static {
        for (int i = 0; i < XP_MAP.length; ++i) {
            TileEntityXPSolidifier.XP_MAP[i] = TileEntityXPSolidifier.getExperienceForLevelImpl(i);
        }
    }
}

