/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.capability.itemhandler.SlotlessItemHandlerConfig;

public class TileEntityInputter
extends TileEntityInventoryBase
implements IButtonReactor,
INumberReactor {
    public static final int OKAY_BUTTON_ID = 133;
    private final SlotlessableItemHandlerWrapper wrapper;
    public int sideToPut;
    public int slotToPutStart;
    public int slotToPutEnd;
    public Map<EnumFacing, SlotlessableItemHandlerWrapper> placeToPut;
    public int sideToPull;
    public int slotToPullStart;
    public int slotToPullEnd;
    public Map<EnumFacing, SlotlessableItemHandlerWrapper> placeToPull;
    public boolean isAdvanced;
    public FilterSettings leftFilter;
    public FilterSettings rightFilter;
    private int lastPutSide;
    private int lastPutStart;
    private int lastPutEnd;
    private int lastPullSide;
    private int lastPullStart;
    private int lastPullEnd;

    public TileEntityInputter(int slots, String name) {
        super(slots, name);
        this.wrapper = new SlotlessableItemHandlerWrapper((IItemHandler)this.inv, null);
        this.sideToPut = -1;
        this.placeToPut = new ConcurrentHashMap<EnumFacing, SlotlessableItemHandlerWrapper>();
        this.sideToPull = -1;
        this.placeToPull = new ConcurrentHashMap<EnumFacing, SlotlessableItemHandlerWrapper>();
        this.leftFilter = new FilterSettings(12, true, true, false, false, 0, -1000);
        this.rightFilter = new FilterSettings(12, true, true, false, false, 0, -2000);
    }

    public TileEntityInputter() {
        super(1, "inputter");
        this.wrapper = new SlotlessableItemHandlerWrapper((IItemHandler)this.inv, null);
        this.sideToPut = -1;
        this.placeToPut = new ConcurrentHashMap<EnumFacing, SlotlessableItemHandlerWrapper>();
        this.sideToPull = -1;
        this.placeToPull = new ConcurrentHashMap<EnumFacing, SlotlessableItemHandlerWrapper>();
        this.leftFilter = new FilterSettings(12, true, true, false, false, 0, -1000);
        this.rightFilter = new FilterSettings(12, true, true, false, false, 0, -2000);
        this.isAdvanced = false;
    }

    @Override
    public void onNumberReceived(double number, int textID, EntityPlayer player) {
        int text = (int)number;
        if (text != -1) {
            if (textID == 0) {
                this.slotToPutStart = Math.max(text, 0);
            }
            if (textID == 1) {
                this.slotToPutEnd = Math.max(text, 0);
            }
            if (textID == 2) {
                this.slotToPullStart = Math.max(text, 0);
            }
            if (textID == 3) {
                this.slotToPullEnd = Math.max(text, 0);
            }
        }
        this.func_70296_d();
    }

    private boolean newPulling() {
        for (EnumFacing side : this.placeToPull.keySet()) {
            WorldUtil.doItemInteraction(this.placeToPull.get(side), this.wrapper, Integer.MAX_VALUE, this.slotToPullStart, this.slotToPullEnd, 0, 1, !this.isAdvanced ? null : this.leftFilter);
            if (!(this.placeToPull instanceof TileEntityItemViewer)) continue;
            break;
        }
        return false;
    }

    private boolean newPutting() {
        if (!this.isAdvanced || this.rightFilter.check(this.inv.getStackInSlot(0))) {
            for (EnumFacing side : this.placeToPut.keySet()) {
                WorldUtil.doItemInteraction(this.wrapper, this.placeToPut.get(side), Integer.MAX_VALUE, 0, 1, this.slotToPutStart, this.slotToPutEnd, null);
                if (!(this.placeToPut instanceof TileEntityItemViewer)) continue;
                break;
            }
        }
        return false;
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        IItemHandler cap;
        Object slotless;
        IItemHandler normal;
        TileEntity tile;
        EnumFacing side;
        BlockPos offset;
        this.placeToPull.clear();
        this.placeToPut.clear();
        if (this.sideToPull != -1 && this.field_145850_b.func_175667_e(offset = this.field_174879_c.func_177972_a(side = WorldUtil.getDirectionBySidesInOrder(this.sideToPull))) && (tile = this.field_145850_b.func_175625_s(offset)) != null) {
            for (EnumFacing facing : EnumFacing.values()) {
                normal = null;
                if (tile.getClass() == TileEntityFurnace.class) {
                    normal = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                } else if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                    normal = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                }
                slotless = null;
                if (ActuallyAdditions.commonCapsLoaded && tile.hasCapability(SlotlessItemHandlerConfig.CAPABILITY, facing)) {
                    slotless = tile.getCapability(SlotlessItemHandlerConfig.CAPABILITY, facing);
                }
                this.placeToPull.put(facing.func_176734_d(), new SlotlessableItemHandlerWrapper(normal, slotless));
            }
            if (this.slotToPullEnd <= 0 && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                this.slotToPullEnd = cap.getSlots();
            }
        }
        if (this.sideToPut != -1 && this.field_145850_b.func_175667_e(offset = this.field_174879_c.func_177972_a(side = WorldUtil.getDirectionBySidesInOrder(this.sideToPut))) && (tile = this.field_145850_b.func_175625_s(offset)) != null) {
            cap = EnumFacing.values();
            int n = ((EnumFacing[])cap).length;
            for (int i = 0; i < n; ++i) {
                EnumFacing facing;
                facing = cap[i];
                normal = null;
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                    normal = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                }
                slotless = null;
                if (ActuallyAdditions.commonCapsLoaded && tile.hasCapability(SlotlessItemHandlerConfig.CAPABILITY, facing)) {
                    slotless = tile.getCapability(SlotlessItemHandlerConfig.CAPABILITY, facing);
                }
                this.placeToPut.put(facing.func_176734_d(), new SlotlessableItemHandlerWrapper(normal, slotless));
            }
            if (this.slotToPutEnd <= 0 && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                this.slotToPutEnd = cap.getSlots();
            }
        }
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        this.leftFilter.onButtonPressed(buttonID);
        this.rightFilter.onButtonPressed(buttonID);
        if (buttonID == 0 || buttonID == 1) {
            this.slotToPutStart = 0;
            this.slotToPutEnd = 0;
        }
        if (buttonID == 2 || buttonID == 3) {
            this.slotToPullStart = 0;
            this.slotToPullEnd = 0;
        }
        if (buttonID == 0) {
            ++this.sideToPut;
        }
        if (buttonID == 1) {
            --this.sideToPut;
        }
        if (buttonID == 2) {
            ++this.sideToPull;
        }
        if (buttonID == 3) {
            --this.sideToPull;
        }
        if (this.sideToPut >= 6) {
            this.sideToPut = -1;
        } else if (this.sideToPut < -1) {
            this.sideToPut = 5;
        } else if (this.sideToPull >= 6) {
            this.sideToPull = -1;
        } else if (this.sideToPull < -1) {
            this.sideToPull = 5;
        }
        this.func_70296_d();
        this.saveDataOnChangeOrWorldStart();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("SideToPut", this.sideToPut);
            compound.func_74768_a("SlotToPut", this.slotToPutStart);
            compound.func_74768_a("SlotToPutEnd", this.slotToPutEnd);
            compound.func_74768_a("SideToPull", this.sideToPull);
            compound.func_74768_a("SlotToPull", this.slotToPullStart);
            compound.func_74768_a("SlotToPullEnd", this.slotToPullEnd);
        }
        this.leftFilter.writeToNBT(compound, "LeftFilter");
        this.rightFilter.writeToNBT(compound, "RightFilter");
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.sideToPut = compound.func_74762_e("SideToPut");
            this.slotToPutStart = compound.func_74762_e("SlotToPut");
            this.slotToPutEnd = compound.func_74762_e("SlotToPutEnd");
            this.sideToPull = compound.func_74762_e("SideToPull");
            this.slotToPullStart = compound.func_74762_e("SlotToPull");
            this.slotToPullEnd = compound.func_74762_e("SlotToPullEnd");
        }
        this.leftFilter.readFromNBT(compound, "LeftFilter");
        this.rightFilter.readFromNBT(compound, "RightFilter");
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!(this.isRedstonePowered || this.ticksElapsed % 30 != 0 || this.sideToPull == this.sideToPut && this.slotToPullStart == this.slotToPutStart && this.slotToPullEnd == this.slotToPutEnd)) {
                if (!StackUtil.isValid(this.inv.getStackInSlot(0)) && this.sideToPull != -1 && this.placeToPull != null) {
                    this.newPulling();
                }
                if (StackUtil.isValid(this.inv.getStackInSlot(0)) && this.sideToPut != -1 && this.placeToPut != null) {
                    this.newPutting();
                }
            }
            if ((this.sideToPut != this.lastPutSide || this.sideToPull != this.lastPullSide || this.slotToPullStart != this.lastPullStart || this.slotToPullEnd != this.lastPullEnd || this.slotToPutStart != this.lastPutStart || this.slotToPutEnd != this.lastPutEnd || this.leftFilter.needsUpdateSend() || this.rightFilter.needsUpdateSend()) && this.sendUpdateWithInterval()) {
                this.lastPutSide = this.sideToPut;
                this.lastPullSide = this.sideToPull;
                this.lastPullStart = this.slotToPullStart;
                this.lastPullEnd = this.slotToPullEnd;
                this.lastPutStart = this.slotToPutStart;
                this.lastPutEnd = this.slotToPutEnd;
                this.leftFilter.updateLasts();
                this.rightFilter.updateLasts();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 0;
    }
}

