/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ItemLeafBlower
extends ItemBase
implements IDisplayStandItem {
    private final boolean isAdvanced;

    public ItemLeafBlower(boolean isAdvanced, String name) {
        super(name);
        this.isAdvanced = isAdvanced;
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isAdvanced ? EnumRarity.EPIC : EnumRarity.RARE;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int time) {
        this.doUpdate(player.field_70170_p, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v), time, stack);
    }

    private boolean doUpdate(World world, int x, int y, int z, int time, ItemStack stack) {
        if (!world.field_72995_K && time <= this.func_77626_a(stack) && (this.isAdvanced || time % 3 == 0)) {
            boolean broke = this.breakStuff(world, x, y, z);
            world.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187782_ds, SoundCategory.PLAYERS, 0.3f, 0.001f);
            return broke;
        }
        return false;
    }

    public boolean breakStuff(World world, int x, int y, int z) {
        ArrayList<BlockPos> breakPositions = new ArrayList<BlockPos>();
        int rangeSides = 5;
        int rangeUp = 1;
        for (int reachX = -rangeSides; reachX < rangeSides + 1; ++reachX) {
            for (int reachZ = -rangeSides; reachZ < rangeSides + 1; ++reachZ) {
                for (int reachY = this.isAdvanced ? -rangeSides : -rangeUp; reachY < (this.isAdvanced ? rangeSides : rangeUp) + 1; ++reachY) {
                    BlockPos pos = new BlockPos(x + reachX, y + reachY, z + reachZ);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block == null || !(block instanceof BlockBush) && !(block instanceof IShearable) || !this.isAdvanced && block.isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos)) continue;
                    breakPositions.add(pos);
                }
            }
        }
        if (!breakPositions.isEmpty()) {
            Collections.shuffle(breakPositions);
            BlockPos theCoord = (BlockPos)breakPositions.get(0);
            IBlockState theState = world.func_180495_p(theCoord);
            theState.func_177230_c().func_176226_b(world, theCoord, theState, 0);
            world.func_175718_b(2001, theCoord, Block.func_176210_f((IBlockState)theState));
            world.func_175698_g(theCoord);
            return true;
        }
        return false;
    }

    @Override
    public boolean update(ItemStack stack, TileEntity tile, int elapsedTicks) {
        return this.doUpdate(tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), elapsedTicks, stack);
    }

    @Override
    public int getUsePerTick(ItemStack stack, TileEntity tile, int elapsedTicks) {
        return 60;
    }
}

