/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import net.minecraft.util.EnumFacing;

public class TileEntityPurificationChamber
extends TileEntityAdvancedElectricMachine<PurificationRecipe> {
    public TileEntityPurificationChamber() {
        super("purifier", BlockStateMachine.MachineType.PURIFICATION_CHAMBER, 200, 1);
    }

    @Override
    public Map<AdvancedMachineInput, PurificationRecipe> getRecipes() {
        return RecipeHandler.Recipe.PURIFICATION_CHAMBER.get();
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.gasTank.canReceive(type) && this.isValidGas(type);
    }

    @Override
    public boolean isValidGas(Gas gas) {
        return RecipeHandler.Recipe.PURIFICATION_CHAMBER.containsRecipe(gas);
    }

    @Override
    public boolean upgradeableSecondaryEfficiency() {
        return true;
    }

    @Override
    public boolean useStatisticalMechanics() {
        return true;
    }
}

