/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.common.PacketHandler;
import mekanism.common.entity.EntityRobit;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRobit
implements IMessageHandler<RobitMessage, IMessage> {
    public IMessage onMessage(RobitMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            EntityRobit robit = (EntityRobit)player.field_70170_p.func_73045_a(message.entityId);
            if (robit != null) {
                switch (message.activeType) {
                    case GUI: {
                        MekanismUtils.openEntityGui(player, (Entity)robit, message.guiID);
                        break;
                    }
                    case FOLLOW: {
                        robit.setFollowing(!robit.getFollowing());
                        break;
                    }
                    case NAME: {
                        robit.func_96094_a(message.name);
                        break;
                    }
                    case GO_HOME: {
                        robit.goHome();
                        break;
                    }
                    case DROP_PICKUP: {
                        robit.setDropPickup(!robit.getDropPickup());
                    }
                }
            }
        }, player);
        return null;
    }

    public static class RobitMessage
    implements IMessage {
        public RobitPacketType activeType;
        public int entityId;
        public int guiID;
        public String name;

        public RobitMessage() {
        }

        public RobitMessage(RobitPacketType type, int entityId) {
            this.activeType = type;
            this.entityId = entityId;
        }

        public RobitMessage(int entityId, @Nonnull String name) {
            this.activeType = RobitPacketType.NAME;
            this.entityId = entityId;
            this.name = name;
        }

        public RobitMessage(int entityId, int guiID) {
            this.activeType = RobitPacketType.GUI;
            this.entityId = entityId;
            this.guiID = guiID;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.activeType.ordinal());
            dataStream.writeInt(this.entityId);
            if (this.activeType == RobitPacketType.NAME) {
                PacketHandler.writeString(dataStream, this.name);
            } else if (this.activeType == RobitPacketType.GUI) {
                dataStream.writeInt(this.guiID);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.activeType = RobitPacketType.values()[dataStream.readInt()];
            this.entityId = dataStream.readInt();
            if (this.activeType == RobitPacketType.NAME) {
                this.name = PacketHandler.readString(dataStream);
            } else if (this.activeType == RobitPacketType.GUI) {
                this.guiID = dataStream.readInt();
            }
        }
    }

    public static enum RobitPacketType {
        GUI,
        FOLLOW,
        NAME,
        GO_HOME,
        DROP_PICKUP;

    }
}

