/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPortableTeleporter
implements IMessageHandler<PortableTeleporterMessage, IMessage> {
    public IMessage onMessage(PortableTeleporterMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            ItemStack itemstack = player.func_184586_b(message.currentHand);
            World world = player.field_70170_p;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemPortableTeleporter) {
                ItemPortableTeleporter item = (ItemPortableTeleporter)itemstack.func_77973_b();
                switch (message.packetType) {
                    case DATA_REQUEST: {
                        this.sendDataResponse(message.frequency, world, player, item, itemstack, message.currentHand);
                        break;
                    }
                    case DATA_RESPONSE: {
                        Mekanism.proxy.handleTeleporterUpdate(message);
                        break;
                    }
                    case SET_FREQ: {
                        FrequencyManager manager1 = this.getManager(message.frequency.isPublic() ? null : player.func_110124_au(), world);
                        Frequency toUse = null;
                        for (Frequency freq : manager1.getFrequencies()) {
                            if (!freq.name.equals(message.frequency.name)) continue;
                            toUse = freq;
                            break;
                        }
                        if (toUse == null) {
                            toUse = new Frequency(message.frequency.name, player.getPersistentID()).setPublic(message.frequency.isPublic());
                            manager1.addFrequency(toUse);
                        }
                        item.setFrequency(itemstack, toUse);
                        this.sendDataResponse(toUse, world, player, item, itemstack, message.currentHand);
                        break;
                    }
                    case DEL_FREQ: {
                        FrequencyManager manager = this.getManager(message.frequency.isPublic() ? null : player.func_110124_au(), world);
                        manager.remove(message.frequency.name, player.func_110124_au());
                        item.setFrequency(itemstack, null);
                        break;
                    }
                    case TELEPORT: {
                        WorldServer teleWorld;
                        TileEntityTeleporter teleporter;
                        Coord4D coords;
                        FrequencyManager manager2 = this.getManager(message.frequency.isPublic() ? null : player.func_110124_au(), world);
                        Frequency found = null;
                        for (Frequency freq : manager2.getFrequencies()) {
                            if (!message.frequency.name.equals(freq.name)) continue;
                            found = freq;
                            break;
                        }
                        if (found == null || (coords = found.getClosestCoords(new Coord4D((Entity)player))) == null || (teleporter = (TileEntityTeleporter)coords.getTileEntity((IBlockAccess)(teleWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(coords.dimensionId)))) == null) break;
                        try {
                            teleporter.didTeleport.add(player.getPersistentID());
                            teleporter.teleDelay = 5;
                            item.setEnergy(itemstack, item.getEnergy(itemstack) - ItemPortableTeleporter.calculateEnergyCost((Entity)player, coords));
                            if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).field_71135_a.field_147365_f = 0;
                            }
                            player.func_71053_j();
                            Mekanism.packetHandler.sendToAllTracking((IMessage)new PacketPortalFX.PortalFXMessage(new Coord4D((Entity)player)), coords);
                            if (player instanceof EntityPlayerMP) {
                                TileEntityTeleporter.teleportPlayerTo((EntityPlayerMP)player, coords, teleporter);
                                TileEntityTeleporter.alignPlayer((EntityPlayerMP)player, coords);
                            }
                            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            Mekanism.packetHandler.sendToAllTracking((IMessage)new PacketPortalFX.PortalFXMessage(coords), coords);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }, player);
        return null;
    }

    public void sendDataResponse(Frequency given, World world, EntityPlayer player, ItemPortableTeleporter item, ItemStack itemstack, EnumHand hand) {
        ArrayList<Frequency> publicFreqs = new ArrayList<Frequency>(this.getManager(null, world).getFrequencies());
        ArrayList<Frequency> privateFreqs = new ArrayList<Frequency>(this.getManager(player.func_110124_au(), world).getFrequencies());
        int status = 3;
        if (given != null) {
            FrequencyManager manager = given.isPublic() ? this.getManager(null, world) : this.getManager(player.func_110124_au(), world);
            boolean found = false;
            for (Frequency iterFreq : manager.getFrequencies()) {
                if (!given.equals(iterFreq)) continue;
                given = iterFreq;
                found = true;
                break;
            }
            if (!found) {
                given = null;
            }
        }
        if (given != null) {
            Coord4D coords;
            double energyNeeded;
            status = given.activeCoords.size() == 0 ? 3 : ((energyNeeded = ItemPortableTeleporter.calculateEnergyCost((Entity)player, coords = given.getClosestCoords(new Coord4D((Entity)player)))) > item.getEnergy(itemstack) ? 4 : 1);
        }
        Mekanism.packetHandler.sendTo(new PortableTeleporterMessage(hand, given, (byte)status, publicFreqs, privateFreqs), (EntityPlayerMP)player);
    }

    public FrequencyManager getManager(UUID owner, World world) {
        if (owner == null) {
            return Mekanism.publicTeleporters;
        }
        if (!Mekanism.privateTeleporters.containsKey(owner)) {
            FrequencyManager manager = new FrequencyManager(Frequency.class, "Teleporter", owner);
            Mekanism.privateTeleporters.put(owner, manager);
            manager.createOrLoad(world);
        }
        return Mekanism.privateTeleporters.get(owner);
    }

    public static class PortableTeleporterMessage
    implements IMessage {
        public PortableTeleporterPacketType packetType;
        public EnumHand currentHand;
        public Frequency frequency;
        public byte status;
        public List<Frequency> publicCache = new ArrayList<Frequency>();
        public List<Frequency> privateCache = new ArrayList<Frequency>();

        public PortableTeleporterMessage() {
        }

        public PortableTeleporterMessage(PortableTeleporterPacketType type, EnumHand hand, Frequency freq) {
            this.packetType = type;
            this.currentHand = hand;
            if (type == PortableTeleporterPacketType.DATA_REQUEST) {
                this.frequency = freq;
            } else if (type == PortableTeleporterPacketType.SET_FREQ) {
                this.frequency = freq;
            } else if (type == PortableTeleporterPacketType.DEL_FREQ) {
                this.frequency = freq;
            } else if (type == PortableTeleporterPacketType.TELEPORT) {
                this.frequency = freq;
            }
        }

        public PortableTeleporterMessage(EnumHand hand, Frequency freq, byte b, List<Frequency> publicFreqs, List<Frequency> privateFreqs) {
            this.packetType = PortableTeleporterPacketType.DATA_RESPONSE;
            this.currentHand = hand;
            this.frequency = freq;
            this.status = b;
            this.publicCache = publicFreqs;
            this.privateCache = privateFreqs;
        }

        public void toBytes(ByteBuf buffer) {
            buffer.writeInt(this.packetType.ordinal());
            if (this.packetType == PortableTeleporterPacketType.DATA_REQUEST) {
                buffer.writeInt(this.currentHand.ordinal());
                if (this.frequency != null) {
                    buffer.writeBoolean(true);
                    PacketHandler.writeString(buffer, this.frequency.name);
                    buffer.writeBoolean(this.frequency.publicFreq);
                } else {
                    buffer.writeBoolean(false);
                }
            } else if (this.packetType == PortableTeleporterPacketType.DATA_RESPONSE) {
                buffer.writeInt(this.currentHand.ordinal());
                if (this.frequency != null) {
                    buffer.writeBoolean(true);
                    PacketHandler.writeString(buffer, this.frequency.name);
                    buffer.writeBoolean(this.frequency.publicFreq);
                } else {
                    buffer.writeBoolean(false);
                }
                buffer.writeByte((int)this.status);
                TileNetworkList data = new TileNetworkList();
                data.add(this.publicCache.size());
                for (Frequency freq : this.publicCache) {
                    freq.write(data);
                }
                data.add(this.privateCache.size());
                for (Frequency freq : this.privateCache) {
                    freq.write(data);
                }
                PacketHandler.encode(data.toArray(), buffer);
            } else if (this.packetType == PortableTeleporterPacketType.SET_FREQ) {
                buffer.writeInt(this.currentHand.ordinal());
                PacketHandler.writeString(buffer, this.frequency.name);
                buffer.writeBoolean(this.frequency.publicFreq);
            } else if (this.packetType == PortableTeleporterPacketType.DEL_FREQ) {
                buffer.writeInt(this.currentHand.ordinal());
                PacketHandler.writeString(buffer, this.frequency.name);
                buffer.writeBoolean(this.frequency.publicFreq);
            } else if (this.packetType == PortableTeleporterPacketType.TELEPORT) {
                buffer.writeInt(this.currentHand.ordinal());
                PacketHandler.writeString(buffer, this.frequency.name);
                buffer.writeBoolean(this.frequency.publicFreq);
            }
        }

        public void fromBytes(ByteBuf buffer) {
            this.packetType = PortableTeleporterPacketType.values()[buffer.readInt()];
            if (this.packetType == PortableTeleporterPacketType.DATA_REQUEST) {
                this.currentHand = EnumHand.values()[buffer.readInt()];
                if (buffer.readBoolean()) {
                    this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
                }
            } else if (this.packetType == PortableTeleporterPacketType.DATA_RESPONSE) {
                int i;
                this.currentHand = EnumHand.values()[buffer.readInt()];
                if (buffer.readBoolean()) {
                    this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
                }
                this.status = buffer.readByte();
                int amount = buffer.readInt();
                for (i = 0; i < amount; ++i) {
                    this.publicCache.add(new Frequency(buffer));
                }
                amount = buffer.readInt();
                for (i = 0; i < amount; ++i) {
                    this.privateCache.add(new Frequency(buffer));
                }
            } else if (this.packetType == PortableTeleporterPacketType.SET_FREQ) {
                this.currentHand = EnumHand.values()[buffer.readInt()];
                this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
            } else if (this.packetType == PortableTeleporterPacketType.DEL_FREQ) {
                this.currentHand = EnumHand.values()[buffer.readInt()];
                this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
            } else if (this.packetType == PortableTeleporterPacketType.TELEPORT) {
                this.currentHand = EnumHand.values()[buffer.readInt()];
                this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
            }
        }
    }

    public static enum PortableTeleporterPacketType {
        DATA_REQUEST,
        DATA_RESPONSE,
        SET_FREQ,
        DEL_FREQ,
        TELEPORT;

    }
}

