/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;

public final class TransporterPathfinder {
    public static List<Destination> getPaths(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, int min) {
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return Collections.emptyList();
        }
        List<InventoryNetwork.AcceptorData> acceptors = network.calculateAcceptors(request, stack);
        return acceptors.stream().map(data -> TransporterPathfinder.getPath(data, start, stack, min)).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    private static boolean checkPath(World world, List<Coord4D> path, TransporterStack stack) {
        for (int i = path.size() - 1; i > 0; --i) {
            TileEntity tile = path.get(i).getTileEntity((IBlockAccess)world);
            ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
            if (transporter != null && (transporter.getColor() == null || transporter.getColor() == stack.color)) continue;
            return false;
        }
        return true;
    }

    private static Destination getPath(InventoryNetwork.AcceptorData data, ILogisticalTransporter start, TransporterStack stack, int min) {
        final TransitRequest.TransitResponse response = data.getResponse();
        if (response.getSendingAmount() >= min) {
            Coord4D dest = data.getLocation();
            List<Coord4D> test = PathfinderCache.getCache(start.coord(), dest, data.getSides());
            if (test != null && TransporterPathfinder.checkPath(start.world(), test, stack)) {
                return new Destination(test, false, response, 0.0).calculateScore(start.world());
            }
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, EnumFacing dir, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, response.getStack(), dir, false);
                }
            }, start.world(), dest, start.coord(), stack);
            List<Coord4D> path = p.getPath();
            if (path.size() >= 2) {
                PathfinderCache.addCachedPath(new PathfinderCache.PathData(start.coord(), dest, p.getSide()), path);
                return new Destination(path, false, response, p.finalScore);
            }
        }
        return null;
    }

    public static Destination getNewBasePath(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    public static Destination getNewRRPath(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, TileEntityLogisticalSorter outputter, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        HashMap<Coord4D, Destination> destPaths = new HashMap<Coord4D, Destination>();
        for (Destination d : paths) {
            Coord4D dest = d.getPath().get(0);
            Destination destination = (Destination)destPaths.get(dest);
            if (destination != null && destination.getPath().size() >= d.getPath().size()) continue;
            destPaths.put(dest, d);
        }
        ArrayList dests = new ArrayList(destPaths.values());
        Collections.sort(dests);
        Destination closest = null;
        if (!dests.isEmpty()) {
            if (outputter.rrIndex <= dests.size() - 1) {
                closest = (Destination)dests.get(outputter.rrIndex);
                if (outputter.rrIndex == dests.size() - 1) {
                    outputter.rrIndex = 0;
                } else if (outputter.rrIndex < dests.size() - 1) {
                    ++outputter.rrIndex;
                }
            } else {
                closest = (Destination)dests.get(dests.size() - 1);
                outputter.rrIndex = 0;
            }
        }
        return closest;
    }

    public static Pair<List<Coord4D>, TransporterStack.Path> getIdlePath(ILogisticalTransporter start, TransporterStack stack) {
        IdlePath d;
        Destination dest;
        if (stack.homeLocation != null) {
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, EnumFacing side, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, stack.itemStack, side, true);
                }
            }, start.world(), stack.homeLocation, start.coord(), stack);
            List<Coord4D> path = p.getPath();
            if (path.size() >= 2) {
                return Pair.of(path, (Object)((Object)TransporterStack.Path.HOME));
            }
            stack.homeLocation = null;
        }
        if ((dest = (d = new IdlePath(start.world(), start.coord(), stack)).find()) == null) {
            return null;
        }
        return Pair.of(dest.getPath(), (Object)((Object)dest.getPathType()));
    }

    public static class Pathfinder {
        private final Set<Coord4D> openSet;
        private final Set<Coord4D> closedSet;
        private final Map<Coord4D, Coord4D> navMap;
        private final Map<Coord4D, Double> gScore;
        private final Map<Coord4D, Double> fScore;
        private final Coord4D start;
        private final Coord4D finalNode;
        private final TransporterStack transportStack;
        private final DestChecker destChecker;
        private double finalScore;
        private EnumFacing side;
        private List<Coord4D> results;
        private World world;

        public Pathfinder(DestChecker checker, World world, Coord4D finishObj, Coord4D startObj, TransporterStack stack) {
            this.destChecker = checker;
            this.world = world;
            this.finalNode = finishObj;
            this.start = startObj;
            this.transportStack = stack;
            this.openSet = new HashSet<Coord4D>();
            this.closedSet = new HashSet<Coord4D>();
            this.navMap = new HashMap<Coord4D, Coord4D>();
            this.gScore = new HashMap<Coord4D, Double>();
            this.fScore = new HashMap<Coord4D, Double>();
            this.results = new ArrayList<Coord4D>();
            this.find(this.start);
        }

        public boolean find(Coord4D start) {
            this.openSet.add(start);
            this.gScore.put(start, 0.0);
            this.fScore.put(start, this.gScore.get(start) + this.getEstimate(start, this.finalNode));
            int blockCount = 0;
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                Coord4D neighbor = start.offset(direction);
                if (this.transportStack.canInsertToTransporter(neighbor.getTileEntity((IBlockAccess)this.world), direction) || neighbor.equals(this.finalNode) && this.destChecker.isValid(this.transportStack, direction, neighbor.getTileEntity((IBlockAccess)this.world))) continue;
                ++blockCount;
            }
            if (blockCount >= 6) {
                return false;
            }
            double maxSearchDistance = start.distanceTo(this.finalNode) * 2;
            ArrayList<EnumFacing> directionsToCheck = new ArrayList<EnumFacing>();
            Coord4D[] neighbors = new Coord4D[EnumFacing.field_82609_l.length];
            TileEntity[] neighborEntities = new TileEntity[neighbors.length];
            while (!this.openSet.isEmpty()) {
                TileEntity neighborEntity;
                Coord4D neighbor;
                Coord4D currentNode = null;
                double lowestFScore = 0.0;
                for (Coord4D node : this.openSet) {
                    if (currentNode != null && !(this.fScore.get(node) < lowestFScore)) continue;
                    currentNode = node;
                    lowestFScore = this.fScore.get(node);
                }
                if (currentNode == null || (double)start.distanceTo(currentNode) > maxSearchDistance) break;
                this.openSet.remove(currentNode);
                this.closedSet.add(currentNode);
                TileEntity currentNodeTile = currentNode.getTileEntity((IBlockAccess)this.world);
                ILogisticalTransporter currentNodeTransporter = CapabilityUtils.getCapability((ICapabilityProvider)currentNodeTile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
                directionsToCheck.clear();
                for (EnumFacing direction : EnumFacing.field_82609_l) {
                    neighbors[direction.ordinal()] = neighbor = currentNode.offset(direction);
                    neighborEntities[direction.ordinal()] = neighborEntity = neighbor.getTileEntity((IBlockAccess)this.world);
                    if (currentNodeTransporter != null && !currentNodeTransporter.canEmitTo(neighborEntity, direction) && (!neighbor.equals(this.finalNode) || !this.destChecker.isValid(this.transportStack, direction, neighborEntities[direction.ordinal()]))) continue;
                    directionsToCheck.add(direction);
                }
                double currentScore = this.gScore.get(currentNode);
                for (EnumFacing direction : directionsToCheck) {
                    neighbor = neighbors[direction.ordinal()];
                    neighborEntity = neighborEntities[direction.ordinal()];
                    if (this.transportStack.canInsertToTransporter(neighborEntity, direction)) {
                        double tentativeG = currentScore + CapabilityUtils.getCapability((ICapabilityProvider)neighborEntity, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, direction.func_176734_d()).getCost();
                        if (this.closedSet.contains(neighbor) && tentativeG >= this.gScore.get(neighbor) || this.openSet.contains(neighbor) && !(tentativeG < this.gScore.get(neighbor))) continue;
                        this.navMap.put(neighbor, currentNode);
                        this.gScore.put(neighbor, tentativeG);
                        this.fScore.put(neighbor, this.gScore.get(neighbor) + this.getEstimate(neighbor, this.finalNode));
                        this.openSet.add(neighbor);
                        continue;
                    }
                    if (!neighbor.equals(this.finalNode) || !this.destChecker.isValid(this.transportStack, direction, neighborEntity)) continue;
                    this.side = direction;
                    this.results = this.reconstructPath(this.navMap, currentNode);
                    return true;
                }
            }
            return false;
        }

        private List<Coord4D> reconstructPath(Map<Coord4D, Coord4D> naviMap, Coord4D currentNode) {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(currentNode);
            if (naviMap.containsKey(currentNode)) {
                path.addAll(this.reconstructPath(naviMap, naviMap.get(currentNode)));
            }
            this.finalScore = this.gScore.get(currentNode) + (double)currentNode.distanceTo(this.finalNode);
            return path;
        }

        public List<Coord4D> getPath() {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(this.finalNode);
            path.addAll(this.results);
            return path;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        private double getEstimate(Coord4D start, Coord4D target2) {
            return start.distanceTo(target2);
        }

        public static class DestChecker {
            public boolean isValid(TransporterStack stack, EnumFacing side, TileEntity tile) {
                return false;
            }
        }
    }

    public static class Destination
    implements Comparable<Destination> {
        private List<Coord4D> path;
        private TransporterStack.Path pathType;
        private TransitRequest.TransitResponse response;
        private double score;

        public Destination(List<Coord4D> list, boolean inv, TransitRequest.TransitResponse ret, double gScore) {
            this.path = new ArrayList<Coord4D>(list);
            if (inv) {
                Collections.reverse(this.path);
            }
            this.response = ret;
            this.score = gScore;
        }

        public Destination setPathType(TransporterStack.Path type) {
            this.pathType = type;
            return this;
        }

        public Destination calculateScore(World world) {
            this.score = 0.0;
            for (Coord4D location : this.path) {
                ILogisticalTransporter capability = CapabilityUtils.getCapability((ICapabilityProvider)location.getTileEntity((IBlockAccess)world), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
                if (capability == null) continue;
                this.score += capability.getCost();
            }
            return this;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.path.hashCode();
            return code;
        }

        public boolean equals(Object dest) {
            return dest instanceof Destination && ((Destination)dest).path.equals(this.path);
        }

        @Override
        public int compareTo(@Nonnull Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return this.path.size() - dest.path.size();
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public TransporterStack.Path getPathType() {
            return this.pathType;
        }

        public List<Coord4D> getPath() {
            return this.path;
        }
    }

    public static class IdlePath {
        private World world;
        private Coord4D start;
        private TransporterStack transportStack;

        public IdlePath(World world, Coord4D obj, TransporterStack stack) {
            this.world = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public Destination find() {
            ArrayList<Coord4D> ret = new ArrayList<Coord4D>();
            ret.add(this.start);
            if (this.transportStack.idleDir == null) {
                EnumFacing newSide = this.findSide();
                if (newSide == null) {
                    return null;
                }
                this.transportStack.idleDir = newSide;
                this.loopSide(ret, newSide);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TileEntity tile = this.start.offset(this.transportStack.idleDir).getTileEntity((IBlockAccess)this.world);
            if (this.transportStack.canInsertToTransporter(tile, this.transportStack.idleDir)) {
                this.loopSide(ret, this.transportStack.idleDir);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TransitRequest request = TransitRequest.getFromTransport(this.transportStack);
            Destination newPath = TransporterPathfinder.getNewBasePath(CapabilityUtils.getCapability((ICapabilityProvider)this.start.getTileEntity((IBlockAccess)this.world), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null), this.transportStack, request, 0);
            if (newPath != null && newPath.getResponse() != null) {
                this.transportStack.idleDir = null;
                newPath.setPathType(TransporterStack.Path.DEST);
                return newPath;
            }
            EnumFacing newSide = this.findSide();
            if (newSide == null) {
                return null;
            }
            this.transportStack.idleDir = newSide;
            this.loopSide(ret, newSide);
            return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
        }

        private void loopSide(List<Coord4D> list, EnumFacing side) {
            Coord4D coord;
            int count = 1;
            while (this.transportStack.canInsertToTransporter((coord = this.start.offset(side, count)).getTileEntity((IBlockAccess)this.world), side)) {
                list.add(coord);
                ++count;
            }
        }

        private EnumFacing findSide() {
            if (this.transportStack.idleDir == null) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    TileEntity tile = this.start.offset(side).getTileEntity((IBlockAccess)this.world);
                    if (!this.transportStack.canInsertToTransporter(tile, side)) continue;
                    return side;
                }
            } else {
                EnumFacing opposite = this.transportStack.idleDir.func_176734_d();
                for (EnumFacing side : EnumSet.complementOf(EnumSet.of(opposite))) {
                    TileEntity tile = this.start.offset(side).getTileEntity((IBlockAccess)this.world);
                    if (!this.transportStack.canInsertToTransporter(tile, side)) continue;
                    return side;
                }
                TileEntity tile = this.start.offset(opposite).getTileEntity((IBlockAccess)this.world);
                if (this.transportStack.canInsertToTransporter(tile, opposite)) {
                    return opposite;
                }
            }
            return null;
        }
    }
}

