/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.MekanismConfig;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class PlayerSound
extends PositionedSound
implements ITickableSound {
    @Nonnull
    private WeakReference<EntityPlayer> playerReference;
    private float lastX;
    private float lastY;
    private float lastZ;
    private float fadeUpStep = 0.1f;
    private float fadeDownStep = 0.1f;
    private boolean donePlaying = false;

    public PlayerSound(@Nonnull EntityPlayer player, @Nonnull ResourceLocation sound) {
        super(sound, SoundCategory.PLAYERS);
        this.playerReference = new WeakReference<EntityPlayer>(player);
        this.lastX = (float)player.field_70165_t;
        this.lastY = (float)player.field_70163_u;
        this.lastZ = (float)player.field_70161_v;
        this.field_147659_g = true;
        this.field_147665_h = 0;
        this.field_147662_b = 0.1f;
    }

    @Nullable
    private EntityPlayer getPlayer() {
        return (EntityPlayer)this.playerReference.get();
    }

    public float func_147649_g() {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            this.lastX = (float)player.field_70165_t;
        }
        return this.lastX;
    }

    public float func_147654_h() {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            this.lastY = (float)player.field_70163_u;
        }
        return this.lastY;
    }

    public float func_147651_i() {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            this.lastZ = (float)player.field_70161_v;
        }
        return this.lastZ;
    }

    public void func_73660_a() {
        EntityPlayer player = this.getPlayer();
        if (player == null || player.field_70128_L) {
            this.donePlaying = true;
            this.field_147662_b = 0.0f;
            return;
        }
        if (this.shouldPlaySound(player)) {
            if (this.field_147662_b < 1.0f) {
                this.field_147662_b = Math.min(1.0f, this.field_147662_b + this.fadeUpStep);
            }
        } else if (this.field_147662_b > 0.0f) {
            this.field_147662_b = Math.max(0.0f, this.field_147662_b - this.fadeDownStep);
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }

    public abstract boolean shouldPlaySound(@Nonnull EntityPlayer var1);

    public float func_147653_e() {
        return (float)((double)super.func_147653_e() * MekanismConfig.current().client.baseSoundVolume.val());
    }

    public static enum SoundType {
        FLAMETHROWER,
        JETPACK,
        GAS_MASK;

    }
}

