/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.Coord4D;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.button.GuiColorButton;
import mekanism.client.gui.filter.GuiModIDFilter;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTModIDFilter
extends GuiModIDFilter<TModIDFilter, TileEntityLogisticalSorter> {
    public GuiTModIDFilter(EntityPlayer player, TileEntityLogisticalSorter tile, int index) {
        super(player, tile);
        this.origFilter = (TModIDFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index);
        this.filter = ((TModIDFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index)).clone();
        this.updateStackList(((TModIDFilter)this.filter).getModID());
    }

    public GuiTModIDFilter(EntityPlayer player, TileEntityLogisticalSorter tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new TModIDFilter();
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTModIDFilter.png");
    }

    @Override
    protected void updateStackList(String modName) {
        this.iterStacks = OreDictCache.getModIDStacks(modName, false);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void addButtons() {
        this.saveButton = new GuiButton(0, this.field_147003_i + 47, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.save"));
        this.field_146292_n.add(this.saveButton);
        this.deleteButton = new GuiButton(1, this.field_147003_i + 109, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        this.backButton = new GuiButtonDisableableImage(2, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11, 176, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.backButton);
        this.defaultButton = new GuiButtonDisableableImage(3, this.field_147003_i + 11, this.field_147009_r + 64, 11, 11, 199, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.defaultButton);
        this.checkboxButton = new GuiButtonDisableableImage(4, this.field_147003_i + 131, this.field_147009_r + 47, 12, 12, 187, 12, -12, this.getGuiLocation());
        this.field_146292_n.add(this.checkboxButton);
        this.colorButton = new GuiColorButton(5, this.field_147003_i + 12, this.field_147009_r + 44, 16, 16, () -> ((TModIDFilter)this.filter).color);
        this.field_146292_n.add(this.colorButton);
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), guiID, 0, 0));
    }
}

