/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTileEntityElement;
import mekanism.client.sound.SoundHandler;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiTabElement<TILE extends TileEntity>
extends GuiTileEntityElement<TILE> {
    protected final int yPos;

    public GuiTabElement(ResourceLocation resource, IGuiWrapper gui, ResourceLocation def, TILE tile, int y) {
        super(resource, gui, def, tile);
        this.yPos = y;
    }

    public abstract void displayForegroundTooltip(int var1, int var2);

    public abstract void buttonClicked();

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth - 26, guiHeight + this.yPos, 26, 26);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= -21 && xAxis <= -3 && yAxis >= this.yPos + 4 && yAxis <= this.yPos + 22;
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (button == 0 && this.inBounds(xAxis, yAxis)) {
            this.buttonClicked();
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiTabElement.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth - 26, guiHeight + this.yPos, 0, 0, 26, 26);
        this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + this.yPos + 4, 26, this.inBounds(xAxis, yAxis) ? 0 : 18, 18, 18);
        GuiTabElement.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiTabElement.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.inBounds(xAxis, yAxis)) {
            this.displayForegroundTooltip(xAxis, yAxis);
        }
        GuiTabElement.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }
}

