/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiTankGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFluidGauge
extends GuiTankGauge<FluidStack, FluidTank> {
    public GuiFluidGauge(IFluidInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y, handler);
    }

    public static GuiFluidGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiFluidGauge gauge = new GuiFluidGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.FLUID;
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        if (((FluidTank)this.infoHandler.getTank()).getFluid() == null || ((FluidTank)this.infoHandler.getTank()).getCapacity() == 0) {
            return 0;
        }
        if (((FluidTank)this.infoHandler.getTank()).getFluidAmount() == Integer.MAX_VALUE) {
            return this.height - 2;
        }
        return ((FluidTank)this.infoHandler.getTank()).getFluidAmount() * (this.height - 2) / ((FluidTank)this.infoHandler.getTank()).getCapacity();
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.dummy) {
            return MekanismRenderer.getFluidTexture((FluidStack)this.dummyType, MekanismRenderer.FluidType.STILL);
        }
        FluidStack fluid = ((FluidTank)this.infoHandler.getTank()).getFluid();
        return MekanismRenderer.getFluidTexture(fluid == null ? (FluidStack)this.dummyType : fluid, MekanismRenderer.FluidType.STILL);
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((FluidStack)this.dummyType).getLocalizedName();
        }
        FluidTank tank = (FluidTank)this.infoHandler.getTank();
        String amountStr = tank.getFluidAmount() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : tank.getFluidAmount() + " mB";
        return tank.getFluid() != null ? LangUtils.localizeFluidStack(tank.getFluid()) + ": " + amountStr : LangUtils.localize("gui.empty");
    }

    @Override
    protected void applyRenderColor() {
        MekanismRenderer.color(this.dummy ? (FluidStack)this.dummyType : ((FluidTank)this.infoHandler.getTank()).getFluid());
    }

    public static interface IFluidInfoHandler
    extends GuiTankGauge.ITankInfoHandler<FluidTank> {
    }
}

