/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiEmbeddedGaugeTile<TILE extends TileEntityContainerBlock>
extends GuiMekanismTile<TILE> {
    protected GuiEmbeddedGaugeTile(TILE tile, Container container) {
        super(tile, container);
    }

    protected abstract ResourceLocation getGaugeResource();

    protected void displayGauge(int xPos, int yPos, int scale, FluidStack fluid) {
        this.displayGauge(xPos, yPos, scale, fluid, 0);
    }

    protected void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, int side) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int start = 0;
        MekanismRenderer.color(fluid);
        TextureAtlasSprite fluidTexture = MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL);
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.func_175175_a(this.field_147003_i + xPos, this.field_147009_r + yPos + 58 - renderRemaining - start, fluidTexture, 16, renderRemaining);
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        MekanismRenderer.resetColor();
        this.field_146297_k.field_71446_o.func_110577_a(this.getGaugeResource());
        this.func_73729_b(this.field_147003_i + xPos, this.field_147009_r + yPos, 176, side == 0 ? 0 : 54, 16, 54);
    }
}

