/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.tools;

import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.ToolOverrideList;
import com.brandon3055.draconicevolution.client.model.tool.ToolTransforms;
import com.brandon3055.draconicevolution.items.tools.DraconicStaffOfPower;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.items.IChaosItem;
import net.foxmcloud.draconicadditions.items.tools.ToolStats;
import net.foxmcloud.draconicadditions.utils.DATextures;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChaoticStaffOfPower
extends DraconicStaffOfPower
implements IChaosItem {
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        super.func_150895_a(tab, subItems);
        if (this.func_194125_a(tab)) {
            ItemStack uberStack = (ItemStack)subItems.remove(subItems.size() - 1);
            this.setChaosStable(uberStack, true);
            subItems.add((Object)uberStack);
        }
    }

    public double getBaseMinSpeedConfig() {
        return ToolStats.CHAOTIC_STAFF_MINING_SPEED;
    }

    public double getBaseAttackSpeedConfig() {
        return ToolStats.CHAOTIC_STAFF_ATTACK_SPEED;
    }

    public double getBaseAttackDamageConfig() {
        return ToolStats.CHAOTIC_STAFF_ATTACK_DAMAGE;
    }

    public int getBaseMinAOEConfig() {
        return ToolStats.BASE_CHAOTIC_MINING_AOE + 1;
    }

    public void loadEnergyStats() {
        int capacity = ToolStats.CHAOTIC_BASE_CAPACITY * 3;
        this.setEnergyStats(capacity, capacity, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.getChaosInfo(stack) != null) {
            tooltip.add(this.getChaosInfo(stack));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public List<String> getValidUpgrades(ItemStack stack) {
        List list = super.getValidUpgrades(stack);
        return list;
    }

    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 4;
    }

    public int getToolTier(ItemStack stack) {
        return 3;
    }

    protected double getMaxAttackAOE(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"attackAOE");
        if (level == 0) {
            return 3.0;
        }
        if (level == 1) {
            return 5.0;
        }
        if (level == 2) {
            return 8.0;
        }
        if (level == 3) {
            return 11.0;
        }
        if (level == 4) {
            return 15.0;
        }
        return 0.0;
    }

    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        if (this.isChaosStable(stack)) {
            super.getFields(stack, registry);
        } else {
            this.addEnchantConfig(stack, registry);
        }
        return registry;
    }

    public double getWeaponAOE(ItemStack stack) {
        if (!this.isChaosStable(stack)) {
            return this.getMaxAttackAOE(stack);
        }
        return ToolConfigHelper.getDoubleField((String)"attackAOE", (ItemStack)stack);
    }

    public int getReaperLevel(ItemStack stack) {
        return 5;
    }

    public void registerRenderer(Feature feature) {
        super.registerRenderer(feature);
        ToolOverrideList.putOverride((Item)this, ChaoticStaffOfPower::handleTransforms);
    }

    @SideOnly(value=Side.CLIENT)
    private static IModelState handleTransforms(ItemCameraTransforms.TransformType transformType, IModelState state) {
        return transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GROUND ? ToolTransforms.STAFF_STATE : state;
    }

    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        return new PairKV((Object)DATextures.CHAOTIC_STAFF_OF_POWER, (Object)new ResourceLocation("draconicadditions", "models/item/tools/chaotic_staff_of_power.obj"));
    }
}

