/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyProvider;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedDouble;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileArmorGenerator
extends TileChaosHolderBase
implements IEnergyProvider,
ITickable,
IChangeListener {
    private int burnSpeed = 50;
    private int baseRFMult = 40;
    public final ManagedInt burnTime = (ManagedInt)this.register("burnTime", (IManagedData)new ManagedInt(1)).saveToTile().saveToItem().syncViaContainer().finish();
    public final ManagedInt burnTimeRemaining = (ManagedInt)this.register("burnTimeRemaining", (IManagedData)new ManagedInt(0)).saveToTile().saveToItem().syncViaContainer().finish();
    public final ManagedDouble burnSpeedMultiplier = (ManagedDouble)this.register("burnSpeedMultiplier", (IManagedData)new ManagedDouble(1.0)).saveToTile().saveToItem().syncViaContainer().finish();
    public final ManagedBool active = (ManagedBool)this.register("active", (IManagedData)new ManagedBool(false)).saveToTile().saveToItem().syncViaTile().trigerUpdate().finish();
    public final ManagedBool powered = (ManagedBool)this.register("powered", (IManagedData)new ManagedBool(false)).saveToTile().saveToItem().syncViaTile().trigerUpdate().finish();

    public TileArmorGenerator() {
        this.setInventorySize(1);
        this.setEnergySyncMode().syncViaContainer();
        this.setCapacityAndTransfer(10000000, 0, 50000);
        this.setShouldRefreshOnBlockChange();
        this.setMaxChaos(0);
    }

    public void func_73660_a() {
        super.update();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = this.active.value = this.burnTimeRemaining.value > 0 && this.getEnergyStored() < this.getMaxEnergyStored();
        if (this.burnTimeRemaining.value > 0 && this.getEnergyStored() < this.getMaxEnergyStored()) {
            int energyGen = (int)((double)this.burnSpeed * this.burnSpeedMultiplier.value);
            if (this.burnTimeRemaining.value < energyGen) {
                energyGen = this.burnTimeRemaining.value;
            }
            this.burnTimeRemaining.value -= energyGen;
            this.energyStorage.modifyEnergyStored(energyGen);
        }
        if (this.burnTimeRemaining.value <= 0 && this.getEnergyStored() < this.getMaxEnergyStored() && !this.powered.value) {
            this.refuel();
        }
        this.energyStorage.modifyEnergyStored(-this.sendEnergyToAll());
    }

    public void refuel() {
        if (this.burnTimeRemaining.value > 0 || this.getEnergyStored() >= this.getMaxEnergyStored()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && !(stack.func_77973_b() instanceof IEnergyContainerItem)) {
            if (stack.func_77973_b() instanceof ItemArmor) {
                NBTTagList list;
                ItemArmor item = (ItemArmor)stack.func_77973_b();
                int itemBurnTime = item.field_77879_b * (item.getMaxDamage(stack) - item.getDamage(stack) + 1) * this.baseRFMult;
                this.burnSpeedMultiplier.value = Math.round(item.field_189415_e > 0.0f ? 1.0f + item.field_189415_e : 1.0f);
                if (stack.func_77948_v() && (list = stack.func_77986_q()) != null) {
                    double lvls = 1.0;
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound compound = list.func_150305_b(i);
                        lvls += (double)compound.func_74765_d("lvl") / 5.0;
                    }
                    itemBurnTime = (int)((double)itemBurnTime * lvls);
                    this.burnSpeedMultiplier.value *= lvls;
                }
                if (itemBurnTime > 0) {
                    if (stack.func_190916_E() == 1) {
                        stack = stack.func_77973_b().getContainerItem(stack);
                    } else {
                        stack.func_190918_g(1);
                    }
                    this.func_70299_a(0, stack);
                    this.burnSpeedMultiplier.value *= 1.0 + (double)this.chaos.value / 80.0;
                    this.burnTimeRemaining.value = this.burnTime.value = (int)((double)itemBurnTime * (1.0 + (double)this.chaos.value / 80.0));
                    if (this.chaos.value > 0) {
                        this.chaos.value -= (int)Math.floor(Math.random() * (double)(this.chaos.value / 100));
                    }
                }
            } else {
                throw new Error("There was a non-armor item in a Armor Generator!  This should never happen...");
            }
        }
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return super.extractEnergy(from, maxExtract, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return super.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return super.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.func_77973_b() instanceof ItemArmor;
    }

    public void onNeighborChange(BlockPos neighbor) {
        this.powered.value = this.field_145850_b.func_175640_z(this.field_174879_c);
    }
}

