/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.chaosritual.tileentity;

import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedDouble;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.foxmcloud.draconicadditions.items.IChaosItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class TileChaosStabilizerCore
extends TileInventoryBase
implements ITickable,
IActivatableTile {
    public final ManagedDouble diameter = (ManagedDouble)this.register("diameter", (IManagedData)new ManagedDouble(1.0)).syncViaTile().finish();
    public final ManagedDouble intensity = (ManagedDouble)this.register("intensity", (IManagedData)new ManagedDouble(0.0)).syncViaTile().finish();
    private static final float chaosDamage = 10.0f;
    private static final double suckRadius = 5.0;
    private static final int delayInMultiblockCheck = 20;
    private double actualDiameter;
    private double actualIntensity;
    private final ManagedInt ritualTicks;
    public final ManagedBool isRitualOngoing;
    public final ManagedBool isMultiblock;
    private Random rand;
    private DamageSource chaosBurst;

    public TileChaosStabilizerCore() {
        this.actualDiameter = this.diameter.value;
        this.actualIntensity = this.intensity.value;
        this.ritualTicks = (ManagedInt)this.register("ritualTicks", (IManagedData)new ManagedInt(0)).syncViaTile().finish();
        this.isRitualOngoing = (ManagedBool)this.register("isRitualOngoing", (IManagedData)new ManagedBool(false)).syncViaTile().finish();
        this.isMultiblock = (ManagedBool)this.register("isMultiblock", (IManagedData)new ManagedBool(false)).syncViaTile().finish();
        this.rand = new Random();
        this.chaosBurst = new DamageSource("chaosBurst").func_76348_h();
        this.setInventorySize(1);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        if (DEEventHandler.serverTicks % 10 == 0 && !this.field_145850_b.field_72995_K) {
            this.checkMultiblock();
            this.updateBlock();
        }
        if (!this.isRitualOngoing.value) {
            if (this.isMultiblock.value) {
                this.intensity.value = 0.25;
                List suckEntities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(5.0));
                for (Entity e : suckEntities) {
                    double dz;
                    double dy;
                    EntityItem eItem;
                    if (e instanceof EntityItem && (eItem = (EntityItem)e).func_92059_d().func_77973_b() instanceof IChaosItem && ((IChaosItem)eItem.func_92059_d().func_77973_b()).isChaosStable(eItem.func_92059_d())) continue;
                    double dx = (double)this.field_174879_c.func_177958_n() + 0.5 - e.field_70165_t;
                    double distance = Math.sqrt(dx * dx + (dy = (double)this.field_174879_c.func_177956_o() + 0.5 - e.field_70163_u) * dy + (dz = (double)this.field_174879_c.func_177952_p() + 0.5 - e.field_70161_v) * dz);
                    if (distance < 1.1 && e instanceof EntityItem) {
                        EntityItem eItem2 = (EntityItem)e;
                        if (eItem2.func_92059_d().func_77973_b() instanceof IChaosItem && this.func_70301_a(0).func_190926_b()) {
                            ItemStack stack = eItem2.func_92059_d();
                            this.func_70299_a(0, stack);
                            this.field_145850_b.func_72900_e(e);
                            this.startRitual();
                            return;
                        }
                        e.field_70159_w -= e.field_70159_w * 5.0 / 1.5;
                        e.field_70181_x -= e.field_70181_x * 5.0 / 1.5;
                        e.field_70179_y -= e.field_70179_y * 5.0 / 1.5;
                        this.playSound(SoundEvents.field_193781_bp, 1.0f, 1.0f);
                        continue;
                    }
                    double limit = 1.0 - distance / 5.0;
                    if (!(limit > 0.0)) continue;
                    limit *= limit;
                    e.field_70159_w += dx / distance * limit * 0.4;
                    e.field_70181_x += dy / distance * limit * 0.4;
                    e.field_70179_y += dz / distance * limit * 0.4;
                }
            } else {
                this.intensity.value = 0.0;
            }
        } else if (this.isMultiblock.value) {
            ++this.ritualTicks.value;
            List suckEntities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(10.0));
            for (Entity e : suckEntities) {
                double limit;
                double dz;
                double dy;
                double dx = (double)this.field_174879_c.func_177958_n() + 0.5 - e.field_70165_t;
                double distance = Math.sqrt(dx * dx + (dy = (double)this.field_174879_c.func_177956_o() + 0.5 - e.field_70163_u) * dy + (dz = (double)this.field_174879_c.func_177952_p() + 0.5 - e.field_70161_v) * dz);
                if (distance < 3.1) {
                    if (e instanceof EntityItem) {
                        EntityItem eItem = (EntityItem)e;
                        if (eItem.func_92059_d().func_77973_b() instanceof IChaosItem) continue;
                        this.field_145850_b.func_72900_e(e);
                        continue;
                    }
                    if (e instanceof EntityPlayer) {
                        EntityPlayer ePlayer = (EntityPlayer)e;
                        if (!(ePlayer instanceof FakePlayer)) {
                            ePlayer.func_70097_a(this.chaosBurst, 5.0f);
                        }
                    } else if (e instanceof EntityLiving) {
                        ((EntityLiving)e).func_70097_a(this.chaosBurst, 20.0f);
                    }
                }
                if (!((limit = 1.0 - distance / 10.0) > 0.0)) continue;
                limit *= limit;
                e.field_70159_w += dx / distance * limit * 0.8;
                e.field_70181_x += dy / distance * limit * 0.8;
                e.field_70179_y += dz / distance * limit * 0.8;
            }
            if (this.ritualTicks.value < 260 && DEEventHandler.serverTicks % 10 == 0) {
                this.playSound(DESoundHandler.sunDialEffect, 1.0f, 0.5f);
            }
            if (this.ritualTicks.value >= 140 && this.ritualTicks.value < 300) {
                if (DEEventHandler.serverTicks % 2 == 0 && this.rand.nextBoolean()) {
                    int i = this.rand.nextInt(4);
                    switch (i) {
                        case 0: {
                            this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), false));
                            break;
                        }
                        case 1: {
                            this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)(this.field_174879_c.func_177958_n() - 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), false));
                            break;
                        }
                        case 2: {
                            this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 2), false));
                            break;
                        }
                        case 3: {
                            this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() - 2), false));
                        }
                    }
                }
                if (this.ritualTicks.value == 240) {
                    this.intensity.value = 1.0;
                }
            }
            if (this.ritualTicks.value >= 300) {
                if (this.checkMultiblock()) {
                    this.endRitual(true);
                } else {
                    this.endRitual(false);
                }
            }
        } else {
            this.endRitual(false);
        }
    }

    private boolean checkMultiblock() {
        this.isMultiblock.value = true;
        ArrayList<BlockPos> check = new ArrayList<BlockPos>();
        check.add(new BlockPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        check.add(new BlockPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        check.add(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2));
        check.add(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2));
        for (BlockPos checkPos : check) {
            if (this.field_145850_b.func_180495_p(checkPos).func_177230_c().equals(Block.func_149684_b((String)"draconicevolution:draconic_block"))) continue;
            this.isMultiblock.value = false;
            return false;
        }
        check.clear();
        check.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))));
        for (BlockPos checkPos : check) {
            if (checkPos.equals((Object)this.field_174879_c) || this.field_145850_b.func_175623_d(checkPos)) continue;
            this.isMultiblock.value = false;
            return false;
        }
        check.clear();
        check.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-2, -2, -2), (BlockPos)this.field_174879_c.func_177982_a(2, -2, 2))));
        check.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(0, -2, -3), (BlockPos)this.field_174879_c.func_177982_a(0, 0, -3))));
        check.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(0, -2, 3), (BlockPos)this.field_174879_c.func_177982_a(0, 0, 3))));
        check.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-3, -2, 0), (BlockPos)this.field_174879_c.func_177982_a(-3, 0, 0))));
        check.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(3, -2, 0), (BlockPos)this.field_174879_c.func_177982_a(3, 0, 0))));
        for (BlockPos checkPos : check) {
            if (this.field_145850_b.func_180495_p(checkPos).func_177230_c().equals(Block.func_149684_b((String)"draconicevolution:infused_obsidian"))) continue;
            this.isMultiblock.value = false;
            return false;
        }
        return true;
    }

    private BlockPos getOffsetPos(Vec3I vec) {
        return this.field_174879_c.func_177973_b((Vec3i)vec.getPos());
    }

    private Vec3I getOffsetVec(BlockPos offsetPos) {
        return new Vec3I(this.field_174879_c.func_177973_b((Vec3i)offsetPos));
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public double func_145833_n() {
        return 40960.0;
    }

    private void sendMessage(EntityPlayer player, String message) {
        if (!this.field_145850_b.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(message, new Object[0]), true);
        }
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        if (!this.field_145850_b.field_72995_K) {
            DESoundHandler.playSoundFromServer((World)this.field_145850_b, (Vec3D)new Vec3D(this.field_174879_c), (SoundEvent)sound, (SoundCategory)SoundCategory.BLOCKS, (float)volume, (float)pitch, (boolean)false, (double)64.0);
        }
    }

    public double getCoreDiameter() {
        if (this.diameter.value > this.actualDiameter) {
            this.actualDiameter += (double)0.005f;
        } else if (this.diameter.value < this.actualDiameter) {
            this.actualDiameter -= (double)0.005f;
        }
        return this.actualDiameter;
    }

    public double getCoreIntensity() {
        if (this.intensity.value > this.actualIntensity) {
            this.actualIntensity += (double)0.001f;
        } else if (this.intensity.value < this.actualIntensity) {
            this.actualIntensity -= (double)0.001f;
        } else if (this.isMultiblock.value && this.rand.nextInt(10) == 0) {
            this.intensity.value += this.rand.nextDouble() / 10.0;
        }
        return this.actualIntensity;
    }

    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.isMultiblock.value || player.func_184812_l_()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b() && stack.func_190916_E() > 0) {
                if (this.func_70301_a(0).func_190926_b()) {
                    if (stack.func_77973_b() instanceof IChaosItem) {
                        IChaosItem item = (IChaosItem)stack.func_77973_b();
                        if (item.isChaosStable(stack)) {
                            this.sendMessage(player, "msg.da.chaosStabilizer.alreadyStabilized");
                        } else if (player.func_184812_l_()) {
                            this.playSound(SoundEvents.field_187525_aO, 1.0f, 0.2f);
                            item.setChaosStable(stack, true);
                        } else {
                            this.sendMessage(player, "msg.da.chaosStabilizer.canStabilize");
                        }
                    } else {
                        this.sendMessage(player, "msg.da.chaosStabilizer.cannotStabilize");
                    }
                } else {
                    this.sendMessage(player, "msg.da.chaosStabilizer.full");
                }
            } else if (!this.func_70301_a(0).func_190926_b()) {
                ItemStack invStack = this.func_70304_b(0);
                this.diameter.value = 1.0;
                this.intensity.value = 0.25;
                if (!this.field_145850_b.field_72995_K) {
                    player.func_191521_c(invStack);
                    this.func_70296_d();
                }
            } else if (!this.field_145850_b.field_72995_K && !player.func_184812_l_()) {
                CustomArmorHandler.ArmorSummery armor = new CustomArmorHandler.ArmorSummery().getSummery(player);
                if (armor.maxProtectionPoints > 10.0f) {
                    if (armor.protectionPoints >= armor.maxProtectionPoints / 2.0f) {
                        player.func_70097_a(new DamageSource("chaosBurst").func_76348_h(), armor.maxProtectionPoints / 2.0f);
                    } else {
                        player.func_70097_a(this.chaosBurst, armor.protectionPoints + 2.5f);
                    }
                } else {
                    player.func_70097_a(this.chaosBurst, 10.0f);
                }
                this.sendMessage(player, "msg.da.chaosStabilizer.emptyHand");
            }
        } else {
            this.sendMessage(player, "msg.da.chaosStabilizer.notMultiblock");
        }
        return true;
    }

    private void startRitual() {
        if (!this.isRitualOngoing.value) {
            this.playSound(SoundEvents.field_187525_aO, 1.0f, 0.2f);
            this.isRitualOngoing.value = true;
            this.diameter.value = 3.0;
            this.intensity.value = 0.8f;
            this.func_70296_d();
            this.updateBlock();
        }
    }

    private void endRitual(boolean complete) {
        if (this.isRitualOngoing.value) {
            this.isRitualOngoing.value = false;
            this.ritualTicks.value = 0;
            this.diameter.value = 1.0;
            this.intensity.value = 0.25;
            ItemStack invStack = this.func_70304_b(0);
            if (!this.field_145850_b.field_72995_K) {
                if (complete) {
                    this.isMultiblock.value = false;
                    ArrayList<BlockPos> check = new ArrayList<BlockPos>();
                    check.add(new BlockPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                    check.add(new BlockPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                    check.add(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2));
                    check.add(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2));
                    for (BlockPos checkPos : check) {
                        this.field_145850_b.func_175698_g(checkPos);
                        this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)checkPos.func_177958_n(), (double)(checkPos.func_177956_o() + 1), (double)checkPos.func_177952_p(), false));
                    }
                    ((IChaosItem)invStack.func_77973_b()).setChaosStable(invStack, true);
                }
                EntityItem chaosItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 1.01, (double)this.field_174879_c.func_177952_p(), invStack);
                this.field_145850_b.func_72838_d((Entity)chaosItem);
                chaosItem.field_70159_w = 0.0;
                chaosItem.field_70181_x = 0.0;
                chaosItem.field_70179_y = 0.0;
            }
            this.func_70296_d();
            this.updateBlock();
        }
    }
}

