/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions;

import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommonMethods {
    public static final DamageSource chaosBurst = new DamageSource("chaosBurst").func_76348_h();
    private static final short gracePeriod = 10;

    public static float subtractShielding(EntityPlayer player, float damageAmount, float entropyDamageStatic, float entropyDamageFactor) {
        CustomArmorHandler.ArmorSummery summary = new CustomArmorHandler.ArmorSummery().getSummery(player);
        if (summary == null || summary.protectionPoints <= 1.0f) {
            return 0.0f;
        }
        float newEntropy = Math.min(summary.entropy + entropyDamageStatic + damageAmount * entropyDamageFactor / 20.0f, 100.0f);
        float totalAbsorbed = 0.0f;
        int remainingPoints = 0;
        for (int i = 0; i < summary.allocation.length; ++i) {
            if (summary.allocation[i] == 0.0f) continue;
            ItemStack armor = (ItemStack)summary.armorStacks.get(i);
            float dmgShear = summary.allocation[i] / summary.protectionPoints;
            float dmg = dmgShear * damageAmount;
            float absorbed = Math.min(dmg, summary.allocation[i]);
            totalAbsorbed += absorbed;
            int n = i;
            summary.allocation[n] = summary.allocation[n] - absorbed;
            remainingPoints = (int)((float)remainingPoints + summary.allocation[i]);
            ItemNBTHelper.setFloat((ItemStack)armor, (String)"ProtectionPoints", (float)summary.allocation[i]);
            ItemNBTHelper.setFloat((ItemStack)armor, (String)"ShieldEntropy", (float)newEntropy);
        }
        summary.saveStacks(player);
        return totalAbsorbed;
    }

    public static float subtractShielding(EntityPlayer player, float damageAmount) {
        return CommonMethods.subtractShielding(player, damageAmount, 1.0f, 1.0f);
    }

    public static boolean cheatCheck(ItemStack stack, World world) {
        long containerTime = ItemNBTHelper.getLong((ItemStack)stack, (String)"cheatCheck", (long)0L);
        long serverTime = world.func_82737_E();
        boolean isCheating = false;
        if (containerTime < serverTime - 10L && containerTime != 0L) {
            isCheating = true;
        }
        ItemNBTHelper.setLong((ItemStack)stack, (String)"cheatCheck", (long)serverTime);
        return isCheating;
    }

    public static void explodeEntity(Vec3D pos, World world) {
        world.func_184134_a(pos.x, pos.y, pos.z, DESoundHandler.beam, SoundCategory.MASTER, 0.25f, 0.5f, false);
        world.func_184134_a(pos.x, pos.y, pos.z, DESoundHandler.fusionComplete, SoundCategory.MASTER, 1.0f, 2.0f, false);
        if (world.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                BCEffectHandler.spawnFX((int)DEParticles.ARROW_SHOCKWAVE, (World)world, (Vec3D)pos, (Vec3D)pos, (double)128.0, (int[])new int[]{2});
            }
        }
    }

    public static void explodeEntity(BlockPos pos, World world) {
        CommonMethods.explodeEntity(new Vec3D(pos), world);
    }
}

