/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSpawnParticle
implements IMessage {
    private int particleID;
    private double xCoord;
    private double yCoord;
    private double zCoord;
    private double xSpeed;
    private double ySpeed;
    private double zSpeed;
    private double viewRange;
    private int[] args;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(int particleID, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, double viewRange, int ... args) {
        this.particleID = particleID;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
        this.viewRange = viewRange;
        this.args = args;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particleID);
        buf.writeDouble(this.xCoord);
        buf.writeDouble(this.yCoord);
        buf.writeDouble(this.zCoord);
        buf.writeDouble(this.xSpeed);
        buf.writeDouble(this.ySpeed);
        buf.writeDouble(this.zSpeed);
        buf.writeDouble(this.viewRange);
        buf.writeByte(this.args.length);
        for (int i : this.args) {
            buf.writeInt(i);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.particleID = buf.readInt();
        this.xCoord = buf.readDouble();
        this.yCoord = buf.readDouble();
        this.zCoord = buf.readDouble();
        this.xSpeed = buf.readDouble();
        this.ySpeed = buf.readDouble();
        this.zSpeed = buf.readDouble();
        this.viewRange = buf.readDouble();
        int argsL = buf.readByte();
        this.args = new int[argsL];
        for (int i = 0; i < argsL; ++i) {
            this.args[i] = buf.readInt();
        }
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketSpawnParticle, IMessage> {
        @Override
        public IMessage handleMessage(PacketSpawnParticle message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                BCEffectHandler.spawnFX(message.particleID, BrandonsCore.proxy.getClientWorld(), message.xCoord, message.yCoord, message.zCoord, message.xSpeed, message.ySpeed, message.zSpeed, message.viewRange, message.args);
            }
            return null;
        }
    }
}

