/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.lib;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;

public class BCFontRenderer
extends FontRenderer {
    private static boolean styleToggleMode = false;
    private static boolean colourSet = false;
    private static int prevFormat = -1;
    private static boolean colourFormatSet = false;
    private static Map<FontRenderer, BCFontRenderer> cashedRenderers = new HashMap<FontRenderer, BCFontRenderer>();
    int recurs = 0;

    public BCFontRenderer(GameSettings gameSettingsIn, ResourceLocation location, TextureManager textureManagerIn, boolean unicode) {
        super(gameSettingsIn, location, textureManagerIn, unicode);
    }

    public String func_78280_d(String str, int wrapWidth) {
        int i = this.func_78259_e(str, wrapWidth);
        if (i <= 0) {
            i = 1;
        }
        if (i <= 2 && str.startsWith("\u00a7")) {
            i = 3;
        }
        if (str.length() <= i) {
            this.recurs = 0;
            return str;
        }
        ++this.recurs;
        String s = str.substring(0, i);
        char c0 = str.charAt(i);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s1 = BCFontRenderer.func_78282_e((String)s) + str.substring(i + (flag ? 1 : 0));
        return s + "\n" + this.func_78280_d(s1, wrapWidth);
    }

    public void func_78255_a(String text, boolean shadow) {
        for (int index = 0; index < text.length(); ++index) {
            boolean flag;
            char c0 = text.charAt(index);
            if (c0 == '\\' && index + 1 < text.length() && text.charAt(index + 1) == '\u00a7') continue;
            if (c0 == '\u00a7' && index + 1 < text.length() && (index == 0 || text.charAt(index - 1) != '\\')) {
                int i1 = "0123456789abcdefklmnor".indexOf(String.valueOf(text.charAt(index + 1)).toLowerCase(Locale.ROOT).charAt(0));
                if (i1 < 16) {
                    if (!styleToggleMode) {
                        this.field_78303_s = false;
                        this.field_78302_t = false;
                        this.field_78299_w = false;
                        this.field_78300_v = false;
                        this.field_78301_u = false;
                    }
                    if (i1 < 0 || i1 > 15) {
                        i1 = 15;
                    }
                    if (shadow) {
                        i1 += 16;
                    }
                    int j1 = this.field_78285_g[i1];
                    if (styleToggleMode) {
                        if (colourFormatSet && prevFormat == j1) {
                            this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
                            colourFormatSet = false;
                        } else {
                            colourFormatSet = true;
                            prevFormat = j1;
                            this.field_78304_r = j1;
                            this.setColor((float)(j1 >> 16) / 255.0f, (float)(j1 >> 8 & 0xFF) / 255.0f, (float)(j1 & 0xFF) / 255.0f, this.field_78305_q);
                        }
                    } else {
                        this.field_78304_r = j1;
                        this.setColor((float)(j1 >> 16) / 255.0f, (float)(j1 >> 8 & 0xFF) / 255.0f, (float)(j1 & 0xFF) / 255.0f, this.field_78305_q);
                    }
                } else if (i1 == 16) {
                    this.field_78303_s = !styleToggleMode || !this.field_78303_s;
                } else if (i1 == 17) {
                    this.field_78302_t = !styleToggleMode || !this.field_78302_t;
                } else if (i1 == 18) {
                    this.field_78299_w = !styleToggleMode || !this.field_78299_w;
                } else if (i1 == 19) {
                    this.field_78300_v = !styleToggleMode || !this.field_78300_v;
                } else if (i1 == 20) {
                    this.field_78301_u = !styleToggleMode || !this.field_78301_u;
                } else if (i1 == 21) {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
                }
                ++index;
                continue;
            }
            int j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0);
            if (this.field_78303_s && j != -1) {
                char c1;
                int k = this.func_78263_a(c0);
                while (k != this.func_78263_a(c1 = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".charAt(j = this.field_78289_c.nextInt("\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".length())))) {
                }
                c0 = c1;
            }
            float f1 = j == -1 || this.field_78293_l ? 0.5f : 1.0f;
            boolean bl = flag = (c0 == '\u0000' || j == -1 || this.field_78293_l) && shadow;
            if (flag) {
                this.field_78295_j -= f1;
                this.field_78296_k -= f1;
            }
            float f = this.func_181559_a(c0, this.field_78301_u);
            if (flag) {
                this.field_78295_j += f1;
                this.field_78296_k += f1;
            }
            if (this.field_78302_t) {
                this.field_78295_j += f1;
                if (flag) {
                    this.field_78295_j -= f1;
                    this.field_78296_k -= f1;
                }
                this.func_181559_a(c0, this.field_78301_u);
                this.field_78295_j -= f1;
                if (flag) {
                    this.field_78295_j += f1;
                    this.field_78296_k += f1;
                }
                f += 1.0f;
            }
            this.doDraw(f);
        }
        if (!styleToggleMode) {
            this.field_78303_s = false;
            this.field_78302_t = false;
            this.field_78299_w = false;
            this.field_78300_v = false;
            this.field_78301_u = false;
        }
    }

    public static BCFontRenderer convert(FontRenderer fontRenderer) {
        if (!cashedRenderers.containsKey(fontRenderer)) {
            BCFontRenderer fr = new BCFontRenderer(Minecraft.func_71410_x().field_71474_y, fontRenderer.field_111273_g, fontRenderer.field_78298_i, fontRenderer.func_82883_a());
            fr.func_110549_a(null);
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)fr);
            cashedRenderers.put(fontRenderer, fr);
        }
        return cashedRenderers.get(fontRenderer);
    }

    public void func_78265_b() {
        if (styleToggleMode) {
            return;
        }
        colourFormatSet = false;
        super.func_78265_b();
    }

    public int func_180455_b(String text, float x, float y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        if (this.field_78294_m) {
            text = this.func_147647_b(text);
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (dropShadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        if (!colourSet && !dropShadow || !styleToggleMode) {
            this.field_78291_n = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_78292_o = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_78306_p = (float)(color & 0xFF) / 255.0f;
            this.field_78305_q = (float)(color >> 24 & 0xFF) / 255.0f;
            this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
            colourSet = true;
        } else if (dropShadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            this.setColor(red, blue, green, alpha);
        }
        this.field_78295_j = x;
        this.field_78296_k = y;
        this.func_78255_a(text, dropShadow);
        if (dropShadow && styleToggleMode) {
            this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
        }
        return (int)this.field_78295_j;
    }

    public int func_78256_a(String text) {
        if (text == null) {
            return 0;
        }
        int width = 0;
        boolean bold = this.field_78302_t && styleToggleMode;
        for (int index = 0; index < text.length(); ++index) {
            char charAtIndex = text.charAt(index);
            int charWidth = this.func_78263_a(charAtIndex);
            if (charAtIndex == '\u00a7' && index > 0 && text.charAt(index - 1) == '\\') {
                charWidth = 6;
            }
            if (text.charAt(index) == '\\' && index + 1 < text.length() && text.charAt(index + 1) == '\u00a7') continue;
            if (charWidth < 0 && index < text.length() - 1) {
                if ((charAtIndex = text.charAt(++index)) != 'l' && charAtIndex != 'L') {
                    if (charAtIndex == 'r' || charAtIndex == 'R') {
                        this.field_78302_t = false;
                        bold = false;
                    }
                } else {
                    this.field_78302_t = !styleToggleMode || !this.field_78302_t;
                    bold = this.field_78302_t;
                }
                charWidth = 0;
            }
            width += charWidth;
            if (!bold || charWidth <= 0) continue;
            ++width;
        }
        return width;
    }

    public int func_78259_e(String str, int wrapWidth) {
        int index;
        boolean bold;
        int totalLength = str.length();
        int currentWidth = 0;
        int lastWord = -1;
        boolean bl = bold = this.field_78302_t && styleToggleMode;
        for (index = 0; index < totalLength; ++index) {
            char charAtIndex = str.charAt(index);
            switch (charAtIndex) {
                case '\n': {
                    --index;
                    break;
                }
                case ' ': {
                    lastWord = index;
                }
                default: {
                    currentWidth += this.func_78263_a(charAtIndex);
                    if (!bold) break;
                    ++currentWidth;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (index >= totalLength - 1) break;
                    if ((c1 = str.charAt(++index)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !BCFontRenderer.func_78272_b((char)c1)) break;
                        bold = false;
                        break;
                    }
                    bold = true;
                }
            }
            if (charAtIndex == '\n') {
                lastWord = ++index;
                break;
            }
            if (currentWidth > wrapWidth) break;
        }
        return index != totalLength && lastWord != -1 && lastWord < index ? lastWord : index;
    }

    public static void setStyleToggleMode(boolean enabled) {
        styleToggleMode = enabled;
        colourSet = false;
    }

    public static boolean isStyleToggleMode() {
        return styleToggleMode;
    }

    public FontState getState() {
        return new FontState(this);
    }

    public void loadState(FontState state) {
        state.apply(this);
    }

    public static class FontState {
        public boolean unicodeFlag;
        public boolean bidiFlag;
        public float red;
        public float blue;
        public float green;
        public float alpha;
        public int textColor;
        public boolean randomStyle;
        public boolean boldStyle;
        public boolean italicStyle;
        public boolean underlineStyle;
        public boolean colourFormatSet;
        public boolean strikethroughStyle;

        protected FontState(BCFontRenderer font) {
            this.unicodeFlag = font.field_78293_l;
            this.bidiFlag = font.field_78294_m;
            this.red = font.field_78291_n;
            this.blue = font.field_78292_o;
            this.green = font.field_78306_p;
            this.alpha = font.field_78305_q;
            this.textColor = font.field_78304_r;
            this.boldStyle = font.field_78302_t;
            this.italicStyle = font.field_78301_u;
            this.underlineStyle = font.field_78300_v;
            this.colourFormatSet = colourFormatSet;
            this.strikethroughStyle = font.field_78299_w;
        }

        private void apply(BCFontRenderer font) {
            font.field_78293_l = this.unicodeFlag;
            font.field_78294_m = this.bidiFlag;
            font.field_78291_n = this.red;
            font.field_78292_o = this.blue;
            font.field_78306_p = this.green;
            font.field_78305_q = this.alpha;
            font.field_78304_r = this.textColor;
            font.field_78302_t = this.boldStyle;
            font.field_78301_u = this.italicStyle;
            font.field_78300_v = this.underlineStyle;
            colourFormatSet = this.colourFormatSet;
            font.field_78299_w = this.strikethroughStyle;
            font.setColor(this.red, this.green, this.blue, this.alpha);
        }
    }
}

