/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.effects;

import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class GuiEffect {
    protected double prevPosX;
    protected double prevPosY;
    protected double posX;
    protected double posY;
    protected double motionX;
    protected double motionY;
    protected boolean isExpired;
    protected Random rand;
    protected int particleTextureIndexX;
    protected int particleTextureIndexY;
    protected int particleAge;
    protected int particleMaxAge;
    protected float particleScale;
    protected float particleGravity;
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    protected float particleAlpha;
    public static double interpPosX;
    public static double interpPosY;
    private World world;
    public double zLevel = 0.0;

    protected GuiEffect(World world, double posX, double posY) {
        this.world = world;
        this.rand = new Random();
        this.particleAlpha = 1.0f;
        this.setPosition(posX, posY);
        this.prevPosX = posX;
        this.prevPosY = posY;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale = (this.rand.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.particleMaxAge = (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f));
        this.particleAge = 0;
    }

    public GuiEffect(World world, double xCoord, double yCoord, double xSpeed, double ySpeed) {
        this(world, xCoord, yCoord);
        this.motionX = xSpeed + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.motionY = ySpeed + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        float f = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float f1 = MathHelper.func_76133_a((double)(this.motionX * this.motionX + this.motionY * this.motionY));
        this.motionX = this.motionX / (double)f1 * (double)f * (double)0.4f;
        this.motionY = this.motionY / (double)f1 * (double)f * (double)0.4f + (double)0.1f;
    }

    public GuiEffect multiplyVelocity(float multiplier) {
        this.motionX *= (double)multiplier;
        this.motionY = (this.motionY - (double)0.1f) * (double)multiplier + (double)0.1f;
        return this;
    }

    public GuiEffect setScale(float scale) {
        this.particleScale = scale;
        return this;
    }

    public void setRBGColorF(float particleRedIn, float particleGreenIn, float particleBlueIn) {
        this.particleRed = particleRedIn;
        this.particleGreen = particleGreenIn;
        this.particleBlue = particleBlueIn;
    }

    public void setAlphaF(float alpha) {
        this.particleAlpha = alpha;
    }

    public boolean isTransparent() {
        return true;
    }

    public void setMaxAge(int p_187114_1_) {
        this.particleMaxAge = p_187114_1_;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        this.motionY -= 0.04 * (double)this.particleGravity;
        this.moveEntity(this.motionX, this.motionY);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
    }

    public void renderParticle(float partialTicks) {
        float minU = (float)this.particleTextureIndexX / 8.0f;
        float maxU = minU + 0.125f;
        float minV = (float)this.particleTextureIndexY / 8.0f;
        float maxV = minV + 0.125f;
        float scale = 8.0f * this.particleScale;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float renderX = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks);
        float renderY = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks);
        vertexbuffer.func_181662_b((double)(renderX - 1.0f * scale), (double)(renderY - 1.0f * scale), this.zLevel).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX - 1.0f * scale), (double)(renderY + 1.0f * scale), this.zLevel).func_187315_a((double)maxU, (double)minV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + 1.0f * scale), (double)(renderY + 1.0f * scale), this.zLevel).func_187315_a((double)minU, (double)minV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + 1.0f * scale), (double)(renderY - 1.0f * scale), this.zLevel).func_187315_a((double)minU, (double)maxV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public int getFXLayer() {
        return 0;
    }

    public void setParticleTextureIndex(int particleTextureIndex) {
        if (this.getFXLayer() != 0) {
            throw new RuntimeException("Invalid call to Particle.setMiscTex");
        }
        this.particleTextureIndexX = particleTextureIndex % 16;
        this.particleTextureIndexY = particleTextureIndex / 16;
    }

    public void nextTextureIndexX() {
        ++this.particleTextureIndexX;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", Pos (" + this.posX + "," + this.posY + "), RGBA (" + this.particleRed + "," + this.particleGreen + "," + this.particleBlue + "," + this.particleAlpha + "), Age " + this.particleAge;
    }

    public void setExpired() {
        this.isExpired = true;
    }

    public void setPosition(double x, double y) {
        this.posX = x;
        this.posY = y;
    }

    public void moveEntity(double x, double y) {
        this.posX += x;
        this.posY += y;
    }

    public boolean isAlive() {
        return !this.isExpired;
    }
}

