/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vat;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.task.PoweredTaskProgress;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.machines.machine.vat.TileVat;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVatProgress
extends MessageTileEntity<TileVat> {
    private float progress = 0.0f;
    private String inputFluidId = null;
    private String outputFluidId = null;

    public PacketVatProgress() {
    }

    public PacketVatProgress(@Nonnull TileVat vat) {
        super((TileEntity)vat);
        IMachineRecipe rec;
        this.progress = vat.getProgress();
        IPoweredTask task = vat.getCurrentTask();
        if (task == null) {
            return;
        }
        for (MachineRecipeInput input : task.getInputs()) {
            if (input.fluid == null || input.fluid.getFluid() == null) continue;
            this.inputFluidId = input.fluid.getFluid().getName();
            break;
        }
        if ((rec = task.getRecipe()) == null) {
            return;
        }
        for (IMachineRecipe.ResultStack res : rec.getCompletedResult(0L, 1.0f, task.getInputs())) {
            FluidStack fluid = res.fluid;
            if (fluid == null || fluid.getFluid() == null) continue;
            this.outputFluidId = fluid.getFluid().getName();
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.progress);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.inputFluidId == null ? "" : this.inputFluidId));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.outputFluidId == null ? "" : this.outputFluidId));
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.progress = buf.readFloat();
        this.inputFluidId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (this.inputFluidId.isEmpty()) {
            this.inputFluidId = null;
        }
        this.outputFluidId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (this.outputFluidId.isEmpty()) {
            this.outputFluidId = null;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketVatProgress, IMessage> {
        public IMessage onMessage(PacketVatProgress message, MessageContext ctx) {
            TileVat tile = (TileVat)message.getTileEntity(message.getWorld(ctx));
            if (tile != null) {
                tile.currentTaskInputFluid = null;
                tile.currentTaskOutputFluid = null;
                if (message.progress < 0.0f) {
                    tile.setClientTask(null);
                } else {
                    tile.setClientTask(new PoweredTaskProgress(message.progress));
                    if (message.inputFluidId != null) {
                        tile.currentTaskInputFluid = FluidRegistry.getFluid((String)message.inputFluidId);
                    }
                    if (message.outputFluidId != null) {
                        tile.currentTaskOutputFluid = FluidRegistry.getFluid((String)message.outputFluidId);
                    }
                }
            }
            return null;
        }
    }
}

