/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vat;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.vat.ContainerVat;
import crazypants.enderio.machines.machine.vat.PacketDumpTank;
import crazypants.enderio.machines.machine.vat.TileVat;
import crazypants.enderio.machines.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiVat
extends GuiInventoryMachineBase<TileVat> {
    @Nonnull
    private static final Rectangle RECTANGLE_OUTPUT_TANK = new Rectangle(132, 12, 15, 47);
    @Nonnull
    private static final Rectangle RECTANGLE_INPUT_TANK = new Rectangle(30, 12, 15, 47);
    @Nonnull
    private static final String GUI_TEXTURE = "vat";
    @Nonnull
    private final IconButton dump1;
    @Nonnull
    private final IconButton dump2;

    public GuiVat(@Nonnull InventoryPlayer inventory, @Nonnull TileVat te) {
        super(te, (Container)new ContainerVat(inventory, te), new String[]{GUI_TEXTURE});
        this.addToolTip(new GuiToolTip(RECTANGLE_INPUT_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Lang.GUI_VAT_ITANK.get());
                this.text.add(LangFluid.MB((IFluidTank)((TileVat)((GuiVat)GuiVat.this).getTileEntity()).inputTank));
            }
        });
        this.addToolTip(new GuiToolTip(RECTANGLE_OUTPUT_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Lang.GUI_VAT_OTANK.get());
                this.text.add(LangFluid.MB((IFluidTank)((TileVat)((GuiVat)GuiVat.this).getTileEntity()).outputTank));
            }
        });
        this.dump1 = new IconButton((IGuiScreen)this, 1, 29, 62, (IWidgetIcon)IconEIO.DUMP_LIQUID);
        this.dump1.setToolTip(new String[]{Lang.GUI_VAT_DUMP.get()});
        this.dump2 = new IconButton((IGuiScreen)this, 2, 131, 62, (IWidgetIcon)IconEIO.VOID_LIQUID);
        this.dump2.setToolTip(new String[]{Lang.GUI_VAT_VOID.get()});
        this.addProgressTooltip(81, 63, 14, 14);
        this.addDrawingElement(new PowerBar(te, this, 12, 12, 42));
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_INPUT_TANK.contains(mouseX, mouseY)) {
            return ((TileVat)this.getTileEntity()).inputTank.getFluid();
        }
        if (RECTANGLE_OUTPUT_TANK.contains(mouseX, mouseY)) {
            return ((TileVat)this.getTileEntity()).outputTank.getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.dump1.onGuiInit();
        this.dump2.onGuiInit();
    }

    @Override
    public void renderSlotHighlights(@Nonnull IoMode mode) {
        super.renderSlotHighlights(mode);
        int x = 30;
        int y = 12;
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            this.renderSlotHighlight(PULL_COLOR, x - 2, y - 2, 19, 51);
        }
        if (mode == IoMode.PUSH || mode == IoMode.PUSH_PULL) {
            x = 132;
            this.renderSlotHighlight(PUSH_COLOR, x - 2, y - 2, 19, 51);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        String str;
        float mult;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        TileVat vat = (TileVat)this.getTileEntity();
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(14) + 1;
            this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 77 - scaled, 176, 14 - scaled, 14, scaled);
            TextureAtlasSprite inputIcon = null;
            if (vat.currentTaskInputFluid != null) {
                inputIcon = RenderUtil.getStillTexture((Fluid)vat.currentTaskInputFluid);
            }
            TextureAtlasSprite outputIcon = null;
            if (vat.currentTaskOutputFluid != null) {
                outputIcon = RenderUtil.getStillTexture((Fluid)vat.currentTaskOutputFluid);
            }
            if (inputIcon != null && outputIcon != null) {
                this.renderVat(inputIcon, outputIcon, vat.getProgress());
            }
        }
        int x = this.field_147003_i + 30;
        int y = this.field_147009_r + 12;
        RenderUtil.renderGuiTank((FluidTank)vat.inputTank, (double)x, (double)y, (double)this.field_73735_i, (double)15.0, (double)47.0);
        x = this.field_147003_i + 132;
        RenderUtil.renderGuiTank((FluidTank)vat.outputTank, (double)x, (double)y, (double)this.field_73735_i, (double)15.0, (double)47.0);
        Fluid outputFluid = !vat.outputTank.isEmpty() ? ((FluidStack)NullHelper.notnull((Object)vat.outputTank.getFluid(), (String)"internal logic error")).getFluid() : vat.currentTaskOutputFluid;
        Fluid inputFluid = !vat.inputTank.isEmpty() ? ((FluidStack)NullHelper.notnull((Object)vat.inputTank.getFluid(), (String)"internal logic error")).getFluid() : vat.currentTaskInputFluid;
        ItemStack inStack = vat.getStackInSlot(0);
        if (!inStack.func_190926_b() && (mult = VatRecipeManager.getInstance().getMultiplierForInput(inputFluid, inStack, outputFluid)) > 0.0f) {
            str = "x" + mult;
            x = this.field_147003_i + 63 - this.field_146289_q.func_78256_a(str) / 2;
            this.field_146289_q.func_175065_a(str, (float)x, (float)(this.field_147009_r + 32), ColorUtil.getRGB((Color)Color.gray), false);
        }
        if (!(inStack = vat.getStackInSlot(1)).func_190926_b() && (mult = VatRecipeManager.getInstance().getMultiplierForInput(inputFluid, inStack, outputFluid)) > 0.0f) {
            str = "x" + mult;
            x = this.field_147003_i + 113 - this.field_146289_q.func_78256_a(str) / 2;
            this.field_146289_q.func_175065_a(str, (float)x, (float)(this.field_147009_r + 32), ColorUtil.getRGB((Color)Color.gray), false);
        }
        this.bindGuiTexture();
        super.func_146976_a(par1, par2, par3);
    }

    private void renderVat(@Nonnull TextureAtlasSprite inputIcon, @Nonnull TextureAtlasSprite outputIcon, float progress) {
        RenderUtil.bindBlockTexture();
        int x = this.field_147003_i + 76;
        int y = this.field_147009_r + 34;
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * (1.0f - progress)));
        this.func_175175_a(x, y, inputIcon, 26, 28);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * progress));
        this.func_175175_a(x, y, outputIcon, 26, 28);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        this.func_73729_b(x, y, 0, 228, 26, 28);
    }

    protected void func_146284_a(@Nonnull GuiButton b) throws IOException {
        super.func_146284_a(b);
        if (b == this.dump1) {
            this.dump(1);
        } else if (b == this.dump2) {
            this.dump(2);
        }
    }

    private void dump(int i) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDumpTank((TileVat)this.getTileEntity(), i));
    }
}

