/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Util;
import com.google.common.collect.Lists;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.config.config.TelePadConfig;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.teleport.telepad.TileTelePad;
import crazypants.enderio.machines.machine.teleport.telepad.gui.ContainerTelePad;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketOpenServerGui;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketSetTarget;
import crazypants.enderio.machines.network.PacketHandler;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTelePad
extends GuiContainerBaseEIO<TileTelePad> {
    private static final int ID_TELEPORT_BUTTON = 96;
    private static final int ID_TRAVEL_SETTINGS_BUTTON = 97;
    GuiButton switchButton;
    GuiButton teleportButton;
    IconButton travelSettingsButton;
    @Nonnull
    private final TextFieldEnder xTF;
    @Nonnull
    private final TextFieldEnder yTF;
    @Nonnull
    private final TextFieldEnder zTF;
    @Nonnull
    private final TextFieldEnder dimTF;
    private static final int powerX = 8;
    private static final int powerY = 9;
    private static final int progressX = 26;
    private static final int progressY = 110;
    private static final int progressScale = 124;
    private static final int fluidX = 8;
    private static final int fluidY = 71;
    private static final int fluidScale = 58;
    @Nonnull
    private static final Rectangle RECTANGLE_TANK = new Rectangle(8, 71, 10, 58);

    private int getPowerScale() {
        return (Integer)TelePadConfig.telepadFluidUse.get() > 0 ? 57 : 120;
    }

    public GuiTelePad(@Nonnull InventoryPlayer playerInv, final @Nonnull TileTelePad te) {
        super(te, (Container)new ContainerTelePad(playerInv, te), "tele_pad");
        this.field_147000_g = 220;
        int settingsBX = this.field_147003_i + this.field_146999_f - 23;
        int settingsBY = this.field_147009_r + 10;
        this.travelSettingsButton = new IconButton((IGuiScreen)this, 97, settingsBX, settingsBY, (IWidgetIcon)IconEIO.GEAR_LIGHT);
        this.travelSettingsButton.setToolTip(new String[]{Lang.GUI_TELEPAD_TO_TRAVEL.get()});
        this.addToolTip(new GuiToolTip(new Rectangle(26, 110, 124, 10), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Math.round(((TileTelePad)GuiTelePad.this.getOwner()).getProgress() * 100.0f) + "%");
            }
        });
        if ((Integer)TelePadConfig.telepadFluidUse.get() > 0) {
            this.addToolTip(new GuiToolTip(RECTANGLE_TANK, new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    this.text.add(Lang.GUI_TELEPAD_TANK.get());
                    this.text.add(LangFluid.MB((IFluidTank)te.getTank()));
                }
            });
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = 48;
        int y = 24;
        int tfHeight = 12;
        int tfWidth = this.field_146999_f - x * 2;
        this.xTF = new TextFieldEnder(fr, x, y, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.yTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i + 2, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.zTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i * 2 + 4, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.dimTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i * 3 + 6, tfWidth, tfHeight, TextFieldEnder.FILTER_NUMERIC);
        this.xTF.func_146180_a(Integer.toString(te.getX()));
        this.yTF.func_146180_a(Integer.toString(te.getY()));
        this.zTF.func_146180_a(Integer.toString(te.getZ()));
        this.dimTF.func_146180_a(Integer.toString(te.getTargetDim()));
        this.xTF.func_146205_d((Boolean)TelePadConfig.telepadLockCoords.get() == false);
        this.yTF.func_146205_d((Boolean)TelePadConfig.telepadLockCoords.get() == false);
        this.zTF.func_146205_d((Boolean)TelePadConfig.telepadLockCoords.get() == false);
        this.dimTF.func_146205_d((Boolean)TelePadConfig.telepadLockDimension.get() == false);
        this.textFields.addAll((Collection)Lists.newArrayList((Object[])new TextFieldEnder[]{this.xTF, this.yTF, this.zTF, this.dimTF}));
        this.addDrawingElement(new PowerBar(te.getEnergy(), this, 8, 9, 10, this.getPowerScale()));
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_TANK.contains(mouseX, mouseY)) {
            return ((TileTelePad)this.getOwner()).getTank().getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    protected int getPowerOutputValue() {
        return ((TileTelePad)this.getOwner()).getUsage();
    }

    protected void updatePowerBarTooltip(List<String> text) {
        text.add(Lang.GUI_TELEPAD_MAX.get(LangPower.RFt(this.getPowerOutputValue())));
        text.add(LangPower.RF(((TileTelePad)this.getOwner()).getEnergy().getEnergyStored(), ((TileTelePad)this.getOwner()).getEnergy().getMaxEnergyStored()));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        String text = Lang.GUI_TELEPAD_TELEPORT.get();
        int textWidth = this.getFontRenderer().func_78256_a(text) + 10;
        int x = this.field_147003_i + this.field_146999_f / 2 - textWidth / 2;
        int y = this.field_147009_r + 83;
        this.teleportButton = new GuiButton(96, x, y, textWidth, 20, text);
        this.func_189646_b(this.teleportButton);
        this.travelSettingsButton.onGuiInit();
        ((ContainerTelePad)this.field_147002_h).createGhostSlots((List<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.xTF.func_146206_l()) {
            this.xTF.func_146180_a(Integer.toString(((TileTelePad)this.getOwner()).getX()));
        }
        if (!this.yTF.func_146206_l()) {
            this.yTF.func_146180_a(Integer.toString(((TileTelePad)this.getOwner()).getY()));
        }
        if (!this.zTF.func_146206_l()) {
            this.zTF.func_146180_a(Integer.toString(((TileTelePad)this.getOwner()).getZ()));
        }
        if (!this.dimTF.func_146206_l()) {
            this.dimTF.func_146180_a(Integer.toString(((TileTelePad)this.getOwner()).getTargetDim()));
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.updateCoords();
    }

    private void updateCoords() {
        BlockPos pos = new BlockPos(this.getIntFromTextBox(this.xTF), this.getIntFromTextBox(this.yTF), this.getIntFromTextBox(this.zTF));
        int targetDim = this.getIntFromTextBox(this.dimTF);
        if (!pos.equals((Object)((TileTelePad)this.getOwner()).getTarget().getLocation()) || targetDim != ((TileTelePad)this.getOwner()).getTargetDim()) {
            ((TileTelePad)this.getOwner()).setCoords(pos);
            ((TileTelePad)this.getOwner()).setTargetDim(targetDim);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetTarget((TileTelePad)this.getOwner(), ((TileTelePad)this.getOwner()).getTarget()));
        }
    }

    private int getIntFromTextBox(TextFieldEnder tf) {
        String text = tf.func_146179_b();
        if ("".equals(text) || "-".equals(text)) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        String name;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int u = (Integer)TelePadConfig.telepadFluidUse.get() > 0 ? 200 : 187;
        int v = 0;
        this.func_73729_b(sx + 8 - 1, sy + 9 - 1, u, v, 12, 122);
        if ((Integer)TelePadConfig.telepadFluidUse.get() > 0 && ((TileTelePad)this.getOwner()).getFluidAmount() > 0) {
            RenderUtil.renderGuiTank((FluidTank)((TileTelePad)this.getOwner()).getTank(), (double)(sx + 8), (double)(sy + 71), (double)0.0, (double)10.0, (double)58.0);
            this.bindGuiTexture();
            this.func_73729_b(sx + 8, sy + 71, 213, v, 10, 58);
        }
        int progressScaled = Util.getProgressScaled((int)124, (IProgressTile)((IProgressTile)this.getOwner()));
        this.func_73729_b(sx + 26, sy + 110, 0, this.field_147000_g, progressScaled, 10);
        FontRenderer fnt = this.getFontRenderer();
        String[] text = new String[]{"X", "Y", "Z", "DIM"};
        for (int i = 0; i < text.length; ++i) {
            TextFieldEnder f = (TextFieldEnder)this.textFields.get(i);
            fnt.func_78276_b((String)NullHelper.first((Object)text[i], (Supplier[])new Supplier[0]), f.field_146209_f - fnt.func_78256_a((String)NullHelper.first((Object[])new String[]{text[i], ""})) / 2 - 10, f.field_146210_g + (f.field_146219_i - fnt.field_78288_b) / 2 + 1, 0);
            if (f.getCanLoseFocus()) continue;
            IconEIO.map.render((IWidgetIcon)IconEIO.LOCK_LOCKED, (double)(f.field_146209_f + f.field_146218_h - 2), (double)(f.field_146210_g - 2), true);
        }
        Entity e = ((TileTelePad)this.getOwner()).getCurrentTarget();
        if (e != null) {
            name = e.func_70005_c_();
            fnt.func_78276_b(name, sx + this.field_146999_f / 2 - fnt.func_78256_a(name) / 2, sy + 110 + fnt.field_78288_b + 6, 0);
        } else if (((TileTelePad)this.getOwner()).wasBlocked()) {
            String s = Lang.GUI_TELEPAD_ERROR_BLOCKED.get();
            fnt.func_78276_b(s, sx + this.field_146999_f / 2 - fnt.func_78256_a(s) / 2, sy + 110 + fnt.field_78288_b + 6, 0xAA0000);
        }
        name = ((TileTelePad)this.getOwner()).getTarget().getName();
        fnt.func_175063_a(name, (float)(sx + this.field_146999_f / 2 - fnt.func_78256_a(name) / 2), (float)(this.getGuiTop() + 10), 0xFFFFFF);
        super.func_146976_a(p_146976_1_, p_146976_2_, p_146976_3_);
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 96) {
            ((TileTelePad)this.getOwner()).teleportAll();
        } else if (button.field_146127_k == 97) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenServerGui((TileTelePad)this.getOwner(), 1));
        }
    }
}

