/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.tank;

import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.machines.machine.tank.EnumTankType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

class TankItemFluidCapability
implements IFluidHandlerItem,
ICapabilityProvider {
    @Nonnull
    protected final ItemStack container;

    TankItemFluidCapability(@Nonnull ItemStack container) {
        this.container = container;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == FluidUtil.getFluidItemCapability();
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == FluidUtil.getFluidItemCapability() ? this : null);
    }

    public IFluidTankProperties[] getTankProperties() {
        return EnumTankType.loadTank(this.container).getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1) {
            return 0;
        }
        SmartTank tank = EnumTankType.loadTank(this.container);
        int ret = tank.fill(resource, doFill);
        EnumTankType.saveTank(this.container, tank);
        return ret;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1) {
            return null;
        }
        SmartTank tank = EnumTankType.loadTank(this.container);
        FluidStack ret = tank.drain(resource, doDrain);
        EnumTankType.saveTank(this.container, tank);
        return ret;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1) {
            return null;
        }
        SmartTank tank = EnumTankType.loadTank(this.container);
        FluidStack ret = tank.drain(maxDrain, doDrain);
        EnumTankType.saveTank(this.container, tank);
        return ret;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }
}

