/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.farm;

import com.enderio.core.common.util.blockiterators.PlanarBlockIterator;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.farm.TileFarmStation;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ticket.SimpleTicket;

public class TicketFarmingStation
extends SimpleTicket<Vec3d> {
    @Nonnull
    private final TileFarmStation farm;

    public TicketFarmingStation(@Nonnull TileFarmStation farm) {
        this.farm = farm;
    }

    public boolean matches(Vec3d toMatch) {
        return toMatch != null && this.farm.canWater(toMatch);
    }

    public void prepare() {
        if (this.getMasterManager() == null && !this.farm.func_145831_w().field_72995_K) {
            int maxSize = (int)(CapacitorKey.FARM_BASE_SIZE.getFloat(DefaultCapacitorData.LVL10) + CapacitorKey.FARM_BONUS_SIZE.getFloat(DefaultCapacitorData.LVL10));
            PlanarBlockIterator blockIterator = new PlanarBlockIterator(this.farm.func_174877_v(), PlanarBlockIterator.Orientation.HORIZONTAL, maxSize);
            HashSet<ChunkPos> chunks = new HashSet<ChunkPos>();
            while (blockIterator.hasNext()) {
                chunks.add(new ChunkPos(blockIterator.next()));
            }
            ChunkPos farmChunk = new ChunkPos(this.farm.func_174877_v());
            chunks.remove(farmChunk);
            FarmlandWaterManager.addCustomTicket((World)this.farm.func_145831_w(), (SimpleTicket)this, (ChunkPos)farmChunk, (ChunkPos[])chunks.toArray(new ChunkPos[0]));
        } else if (!this.isValid()) {
            this.validate();
        }
    }
}

