/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.alloy;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.alloy.ContainerAlloySmelter;
import crazypants.enderio.machines.machine.alloy.ContainerAlloySmelterProxy;
import crazypants.enderio.machines.machine.alloy.OperatingProfile;
import crazypants.enderio.machines.machine.alloy.TileAlloySmelter;
import java.awt.Rectangle;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.util.SoundEvent;

public abstract class GuiAlloySmelter<T extends TileAlloySmelter>
extends GuiInventoryMachineBase<T>
implements ContainerAlloySmelterProxy {
    @Nonnull
    private final IconButton vanillaFurnaceButton;
    @Nonnull
    private final GuiToolTip vanillaFurnaceTooltip;
    @Nonnull
    protected OperatingProfile mode;
    protected static final int SMELT_MODE_BUTTON_ID = 76;

    @Nonnull
    public static <E extends TileAlloySmelter> GuiAlloySmelter<E> create(@Nonnull InventoryPlayer playerInv, @Nonnull E te) {
        if (te instanceof TileAlloySmelter.Simple) {
            return new Simple(playerInv, (TileAlloySmelter.Simple)te);
        }
        if (te instanceof TileAlloySmelter.Furnace) {
            return new Furnace(playerInv, (TileAlloySmelter.Furnace)te);
        }
        if (te instanceof TileAlloySmelter.Enhanced) {
            return new Enhanced(playerInv, (TileAlloySmelter.Enhanced)te);
        }
        return new Normal(playerInv, te);
    }

    public GuiAlloySmelter(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull T furnaceInventory) {
        super(furnaceInventory, (Container)ContainerAlloySmelter.create(par1InventoryPlayer, furnaceInventory), OperatingProfile.getAllGuiTextures());
        this.mode = ((TileAlloySmelter)furnaceInventory).getOperatingProfile();
        this.vanillaFurnaceTooltip = new GuiToolTip(new Rectangle(this.field_146999_f - 5 - 16, 62, 16, 16), (String[])null);
        this.vanillaFurnaceTooltip.setIsVisible(this.mode.canSwitchProfiles());
        this.vanillaFurnaceButton = new IconButton((IGuiScreen)this, 76, this.field_147003_i + this.vanillaFurnaceTooltip.getBounds().x, this.field_147009_r + this.vanillaFurnaceTooltip.getBounds().y, this.mode.getIcon());
        this.vanillaFurnaceButton.field_146125_m = this.mode.canSwitchProfiles();
        this.vanillaFurnaceButton.setIconMargin(2, 2);
        this.redstoneButton.setIsVisible(this.mode.hasRedstoneControl());
        this.addProgressTooltip(55, 35, 14, 14);
        this.addProgressTooltip(103, 35, 14, 14);
        this.addDrawingElement(new PowerBar((IPowerBarData)furnaceInventory, this));
    }

    private OperatingProfile getMode() {
        return this.mode.fromMode(((TileAlloySmelter)this.getTileEntity()).getMode());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.vanillaFurnaceButton.field_146128_h = this.field_147003_i + this.vanillaFurnaceTooltip.getBounds().x;
        this.vanillaFurnaceButton.field_146129_i = this.field_147009_r + this.vanillaFurnaceTooltip.getBounds().y;
        this.field_146292_n.add(this.vanillaFurnaceButton);
        this.addToolTip(this.vanillaFurnaceTooltip);
        this.updateVanillaFurnaceButton();
    }

    @Override
    protected void renderSlotHighlight(int slot, @Nonnull Vector4f col) {
        if (((TileAlloySmelter)this.getTileEntity()).getSlotDefinition().isOutputSlot(slot)) {
            this.renderSlotHighlight(col, 75, 54, 24, 24);
        } else {
            super.renderSlotHighlight(slot, col);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        if (button == 1 && this.vanillaFurnaceButton.func_146115_a() && this.getMode().canSwitchProfiles()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.actionPerformed((GuiButton)this.vanillaFurnaceButton, 1);
        }
        super.func_73864_a(x, y, button);
    }

    protected void func_146284_a(@Nonnull GuiButton par1GuiButton) throws IOException {
        this.actionPerformed(par1GuiButton, 0);
    }

    private void actionPerformed(GuiButton button, int mbutton) throws IOException {
        if (button.field_146127_k == 76) {
            this.doSetMode(mbutton == 0 ? ((TileAlloySmelter)this.getTileEntity()).getMode().next() : ((TileAlloySmelter)this.getTileEntity()).getMode().prev());
        } else {
            super.func_146284_a(button);
        }
    }

    private void updateVanillaFurnaceButton() {
        this.vanillaFurnaceButton.setIcon(this.getMode().getIcon());
        this.vanillaFurnaceTooltip.setToolTipText(new String[]{Lang.GUI_ALLOY_MODE.get(), this.getMode().getLang().get()});
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        this.updateVanillaFurnaceButton();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture(this.getMode().getGuiTextureID());
        int sx = this.field_147003_i;
        int sy = this.field_147009_r;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(14) + 1;
            this.func_73729_b(sx + 55, sy + 49 - scaled, 176, 14 - scaled, 14, scaled);
            this.func_73729_b(sx + 103, sy + 49 - scaled, 176, 14 - scaled, 14, scaled);
        }
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    @Nonnull
    protected String getDocumentationPage() {
        return "enderio:alloy_smelter";
    }

    public static class Furnace
    extends GuiAlloySmelter<TileAlloySmelter.Furnace> {
        public Furnace(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TileAlloySmelter.Furnace furnaceInventory) {
            super(par1InventoryPlayer, furnaceInventory);
        }

        @Override
        @Nonnull
        protected String getDocumentationPage() {
            return "enderio:furnace";
        }
    }

    public static class Simple
    extends GuiAlloySmelter<TileAlloySmelter.Simple> {
        public Simple(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TileAlloySmelter.Simple furnaceInventory) {
            super(par1InventoryPlayer, furnaceInventory);
        }
    }

    public static class Normal
    extends GuiAlloySmelter<TileAlloySmelter> {
        public Normal(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TileAlloySmelter furnaceInventory) {
            super(par1InventoryPlayer, furnaceInventory);
        }
    }

    public static class Enhanced
    extends GuiAlloySmelter<TileAlloySmelter> {
        public Enhanced(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TileAlloySmelter.Enhanced furnaceInventory) {
            super(par1InventoryPlayer, furnaceInventory);
        }
    }
}

