/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.sensor;

import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.invpanel.capability.CapabilityDatabaseHandler;
import crazypants.enderio.base.invpanel.capability.IDatabaseHandler;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.task.ContinuousTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.invpanel.init.InvpanelObject;
import crazypants.enderio.invpanel.network.PacketHandler;
import crazypants.enderio.invpanel.network.sensor.PacketActive;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileInventoryPanelSensor
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    private int slowstart = 10;
    @Store
    private int startCount = 32;
    @Store
    private int stopCount = 64;
    private int currentSignal = 0;
    @Store
    @Nonnull
    private ItemStack itemToCheck = ItemStack.field_190927_a;
    private boolean active = false;

    public TileInventoryPanelSensor() {
        super(new SlotDefinition(0, 0, 0), CapacitorKey.LEGACY_ENERGY_INTAKE, CapacitorKey.LEGACY_ENERGY_BUFFER, CapacitorKey.LEGACY_ENERGY_USE);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return InvpanelObject.blockInventoryPanelSensor.getUnlocalisedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack item) {
        return false;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode == IoMode.NONE || mode == IoMode.DISABLED;
    }

    @Override
    protected void checkProgress(boolean redstoneChecksPassed) {
        this.usePower();
        if (this.slowstart > 0) {
            --this.slowstart;
            return;
        }
        if (this.shouldDoWorkThisTick(10)) {
            if (!this.itemToCheck.func_190926_b()) {
                IInventoryDatabaseServer db = this.getInventoryDB();
                if (db != null) {
                    int invHasCount = 0;
                    IServerItemEntry entry = db.lookupItem(this.itemToCheck, null, false);
                    if (entry != null) {
                        invHasCount = entry.countItems();
                    }
                    this.updateRedstone(invHasCount);
                } else {
                    this.setCurrentSignal(0);
                }
            } else if (this.isEmitting()) {
                this.setCurrentSignal(0);
            }
        }
    }

    private void updateRedstone(int invHasCount) {
        if (this.itemToCheck.func_190926_b()) {
            this.setCurrentSignal(0);
            return;
        }
        if (this.isEmitting()) {
            if (invHasCount >= this.stopCount) {
                this.setCurrentSignal(0);
            }
        } else if (invHasCount < this.startCount) {
            this.setCurrentSignal(15);
        }
    }

    private void setCurrentSignal(int newVal) {
        if (this.currentSignal == newVal) {
            return;
        }
        this.currentSignal = newVal;
        this.setActive(this.isEmitting());
        PacketHandler.sendToAllAround((IMessage)new PacketActive(this), (TileEntity)this);
        this.broadcastSignal();
        this.func_70296_d();
    }

    private void broadcastSignal() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
    }

    @Override
    protected IPoweredTask createTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Nullable
    public IInventoryDatabaseServer getInventoryDB() {
        for (EnumFacing dir : EnumFacing.values()) {
            IDatabaseHandler dbHandler;
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (te == null || !te.hasCapability(CapabilityDatabaseHandler.DATABASE_HANDLER_CAPABILITY, dir.func_176734_d()) || (dbHandler = (IDatabaseHandler)te.getCapability(CapabilityDatabaseHandler.DATABASE_HANDLER_CAPABILITY, dir.func_176734_d())) == null) continue;
            return dbHandler.getDatabase();
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Nonnull
    public ItemStack getItemToCheck() {
        return this.itemToCheck;
    }

    public void setItemToCheck(@Nonnull ItemStack itemToCheck) {
        this.itemToCheck = itemToCheck;
        this.func_70296_d();
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void setStartCount(int startCount) {
        this.startCount = startCount;
        this.func_70296_d();
    }

    public int getStopCount() {
        return this.stopCount;
    }

    public void setStopCount(int stopCount) {
        this.stopCount = stopCount;
        this.func_70296_d();
    }

    public boolean isEmitting() {
        return this.getRedstoneLevel() > 0;
    }

    public int getRedstoneLevel() {
        return this.currentSignal;
    }
}

