/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.chest;

import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.base.te.ICap;
import crazypants.enderio.base.machine.interfaces.IHasFillLevel;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.invpanel.chest.EnumChestSize;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;

@Storable
public abstract class TileInventoryChest
extends AbstractCapabilityMachineEntity
implements IPaintable.IPaintableTileEntity,
IHasFillLevel {
    @Nonnull
    private final EnumChestSize size;
    private boolean lastState = false;

    private TileInventoryChest(@Nonnull EnumChestSize size) {
        super(null, size.getIntake(), size.getBuffer(), size.getUse());
        this.size = size;
        for (int i = 0; i < size.getSlots(); ++i) {
            this.getInventory().add(EnderInventory.Type.INOUT, "slot" + i, new InventorySlot());
        }
        this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.BASIC_CAPACITOR.ordinal()));
        this.addICap(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facingIn -> this.hasPower() ? ICap.NEXT : ICap.DENY);
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    protected void processTasks(boolean redstoneCheck) {
        boolean hasPower = this.getEnergy().useEnergy();
        if (this.lastState != hasPower) {
            this.lastState = hasPower;
            this.updateClients = true;
        }
    }

    public int getComparatorInputOverride() {
        int count = 0;
        for (InventorySlot slot : this.getInventory().getView(EnderInventory.Type.INOUT)) {
            if (!Prep.isValid(slot.getStackInSlot(0))) continue;
            ++count;
        }
        return count == 0 ? 0 : 14 * count / this.size.getSlots() + 1;
    }

    @Storable
    public static class Warehouse13
    extends TileInventoryChest {
        public Warehouse13() {
            super(EnumChestSize.WAREHOUSE13);
        }
    }

    @Storable
    public static class Warehouse
    extends TileInventoryChest {
        public Warehouse() {
            super(EnumChestSize.WAREHOUSE);
        }
    }

    @Storable
    public static class Enormous
    extends TileInventoryChest {
        public Enormous() {
            super(EnumChestSize.ENORMOUS);
        }
    }

    @Storable
    public static class Huge
    extends TileInventoryChest {
        public Huge() {
            super(EnumChestSize.HUGE);
        }
    }

    @Storable
    public static class Large
    extends TileInventoryChest {
        public Large() {
            super(EnumChestSize.LARGE);
        }
    }

    @Storable
    public static class Big
    extends TileInventoryChest {
        public Big() {
            super(EnumChestSize.BIG);
        }
    }

    @Storable
    public static class Medium
    extends TileInventoryChest {
        public Medium() {
            super(EnumChestSize.MEDIUM);
        }
    }

    @Storable
    public static class Small
    extends TileInventoryChest {
        public Small() {
            super(EnumChestSize.SMALL);
        }
    }

    @Storable
    public static class Tiny
    extends TileInventoryChest {
        public Tiny() {
            super(EnumChestSize.TINY);
        }
    }
}

