/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class AbstractTankConduitNetwork<T extends AbstractTankConduit>
extends AbstractConduitNetwork<ILiquidConduit, T> {
    protected FluidStack liquidType;
    protected boolean fluidTypeLocked = false;

    protected AbstractTankConduitNetwork(@Nonnull Class<T> cl) {
        super(cl, ILiquidConduit.class);
    }

    public FluidStack getFluidType() {
        return this.liquidType;
    }

    @Override
    public void addConduit(@Nonnull T con) {
        super.addConduit(con);
        ((AbstractTankConduit)con).setFluidType(this.liquidType);
        if (((AbstractTankConduit)con).fluidTypeLocked && !this.fluidTypeLocked) {
            this.setFluidTypeLocked(true);
        }
    }

    public boolean setFluidType(FluidStack newType) {
        if (this.liquidType != null && this.liquidType.isFluidEqual(newType)) {
            return false;
        }
        if (newType != null) {
            this.liquidType = newType.copy();
            this.liquidType.amount = 0;
        } else {
            this.liquidType = null;
        }
        for (AbstractTankConduit conduit : this.getConduits()) {
            conduit.setFluidType(this.liquidType);
        }
        return true;
    }

    public void setFluidTypeLocked(boolean fluidTypeLocked) {
        if (this.fluidTypeLocked == fluidTypeLocked) {
            return;
        }
        this.fluidTypeLocked = fluidTypeLocked;
        for (AbstractTankConduit conduit : this.getConduits()) {
            conduit.setFluidTypeLocked(fluidTypeLocked);
        }
    }

    public boolean canAcceptLiquid(FluidStack acceptable) {
        return AbstractTankConduitNetwork.areFluidsCompatable(this.liquidType, acceptable);
    }

    public static boolean areFluidsCompatable(FluidStack a, FluidStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.isFluidEqual(b);
    }

    public int getTotalVolume() {
        int totalVolume = 0;
        for (AbstractTankConduit con : this.getConduits()) {
            totalVolume += con.getTank().getFluidAmount();
        }
        return totalVolume;
    }
}

