/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.oc.network;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduit.oc.conduit.IOCConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import crazypants.enderio.util.EnumReader;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOCConduitSignalColor
extends AbstractConduitPacket.Sided<IOCConduit> {
    @Nonnull
    private DyeColor col;

    public PacketOCConduitSignalColor() {
        this.col = DyeColor.BLACK;
    }

    public PacketOCConduitSignalColor(@Nonnull IOCConduit con, @Nonnull EnumFacing dir) {
        super(con, dir);
        this.col = con.getSignalColor(dir);
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeShort(this.col.ordinal());
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.col = EnumReader.get(DyeColor.class, buf.readShort());
    }

    public static class Handler
    implements IMessageHandler<PacketOCConduitSignalColor, IMessage> {
        public IMessage onMessage(PacketOCConduitSignalColor message, MessageContext ctx) {
            IOCConduit con = (IOCConduit)message.getConduit(ctx);
            if (con != null) {
                con.setSignalColor(message.dir, message.col);
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }
    }
}

