/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.teleport.packet;

import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPassword
extends MessageTileEntity<TileEntityBase> {
    @Nonnull
    private ItemStack stack = Prep.getEmpty();
    private int slot;
    private boolean setLabel;

    public PacketPassword() {
    }

    private PacketPassword(@Nonnull TileEntityBase tile) {
        super((TileEntity)tile);
    }

    public static IMessage setPassword(@Nonnull TileEntityBase te, int slot, @Nonnull ItemStack stack) {
        PacketPassword msg = new PacketPassword(te);
        msg.slot = slot;
        msg.stack = stack;
        msg.setLabel = false;
        return msg;
    }

    public static PacketPassword setLabel(@Nonnull TileEntityBase te, @Nonnull ItemStack stack) {
        PacketPassword msg = new PacketPassword(te);
        msg.slot = 0;
        msg.stack = stack;
        msg.setLabel = true;
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.slot = buf.readShort();
        this.setLabel = buf.readBoolean();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.slot);
        buf.writeBoolean(this.setLabel);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<PacketPassword, IMessage> {
        public IMessage onMessage(PacketPassword msg, MessageContext ctx) {
            TileEntityBase te = (TileEntityBase)msg.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
            if (te instanceof ITravelAccessable && ((ITravelAccessable)te).canUiBeAccessed((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                if (Prep.isValid(msg.stack)) {
                    msg.stack.func_190920_e(1);
                }
                if (msg.setLabel) {
                    ((ITravelAccessable)te).setItemLabel(msg.stack);
                } else {
                    ((ITravelAccessable)te).getPassword().set(msg.slot, (Object)msg.stack);
                    ((ITravelAccessable)te).clearAuthorisedUsers();
                }
                BlockPos pos = msg.getPos();
                IBlockState bs = te.func_145831_w().func_180495_p(pos);
                te.func_145831_w().func_184138_a(pos, bs, bs, 3);
            }
            return null;
        }
    }
}

