/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.util;

import com.google.common.base.Throwables;
import crazypants.enderio.base.render.util.CompositeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

public class QuadCollector {
    private static final BlockRenderLayer BREAKING = null;
    private final List<BakedQuad>[] table = new List[QuadCollector.mkKey(EnumFacing.values()[EnumFacing.values().length - 1], BlockRenderLayer.values()[BlockRenderLayer.values().length - 1]) + 1];

    public String toString() {
        String a = "";
        for (int i = 0; i < this.table.length; ++i) {
            a = this.table[i] == null ? a + "- " : a + this.table[i].size() + " ";
        }
        return "QuadCollector@" + Integer.toHexString(this.hashCode()) + " [table=" + a + "]";
    }

    private static Integer mkKey(EnumFacing side, BlockRenderLayer pass) {
        return (side == null ? 0 : side.ordinal() + 1) * (BlockRenderLayer.values().length + 1) + (pass == BREAKING ? 0 : pass.ordinal() + 1);
    }

    public void addQuads(EnumFacing side, BlockRenderLayer pass, List<BakedQuad> quads) {
        if (quads != null && !quads.isEmpty()) {
            Integer key = QuadCollector.mkKey(side, pass);
            if (this.table[key] == null) {
                this.table[key.intValue()] = new ArrayList<BakedQuad>(quads);
            } else {
                if (!(this.table[key] instanceof ArrayList)) {
                    this.table[key.intValue()] = new ArrayList<BakedQuad>(this.table[key]);
                }
                this.table[key].addAll(quads);
                ((ArrayList)this.table[key]).trimToSize();
            }
        }
    }

    @Nonnull
    public List<BakedQuad> getQuads(EnumFacing side, BlockRenderLayer pass) {
        List<BakedQuad> list = this.table[QuadCollector.mkKey(side, pass)];
        if (list == null || list.isEmpty()) {
            if (pass == BREAKING) {
                List<BakedQuad> result = Collections.emptyList();
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    result = CompositeList.create(result, this.table[QuadCollector.mkKey(side, layer)]);
                }
                return result;
            }
            return Collections.emptyList();
        }
        return list;
    }

    public void addFriendlyBlockStates(BlockRenderLayer pass, List<IBlockState> states) {
        if (states == null || states.isEmpty()) {
            return;
        }
        BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        for (IBlockState state : states) {
            if (state == null) continue;
            IBakedModel model = modelShapes.func_178125_b(state);
            List generalQuads = model.func_188616_a(state, null, 0L);
            if (!generalQuads.isEmpty()) {
                this.addQuads(null, pass, generalQuads);
            }
            for (EnumFacing face : EnumFacing.values()) {
                List faceQuads = model.func_188616_a(state, face, 0L);
                if (faceQuads.isEmpty()) continue;
                this.addQuads(face, pass, faceQuads);
            }
        }
    }

    @Nullable
    public String addUnfriendlybakedModel(BlockRenderLayer pass, IBakedModel model, IBlockState state, long rand) {
        if (model == null) {
            return null;
        }
        try {
            this.addQuads(null, pass, model.func_188616_a(state, null, rand));
            for (EnumFacing face : EnumFacing.values()) {
                this.addQuads(face, pass, model.func_188616_a(state, face, rand));
            }
        }
        catch (Throwable t) {
            return Throwables.getStackTraceAsString((Throwable)t);
        }
        return null;
    }

    public void addFriendlybakedModel(BlockRenderLayer pass, IBakedModel model, @Nullable IBlockState state, long rand) {
        if (model != null) {
            BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)pass);
            List generalQuads = model.func_188616_a(state, null, rand);
            if (!generalQuads.isEmpty()) {
                this.addQuads(null, pass, generalQuads);
            }
            for (EnumFacing face : EnumFacing.values()) {
                List faceQuads = model.func_188616_a(state, face, rand);
                if (faceQuads.isEmpty()) continue;
                this.addQuads(face, pass, faceQuads);
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
    }

    public Iterable<BlockRenderLayer> getBlockLayers() {
        return new BlockRenderLayerIterable();
    }

    public boolean isEmpty() {
        for (List<BakedQuad> entry : this.table) {
            if (entry == null || entry.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public QuadCollector combine(@Nullable QuadCollector other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        QuadCollector result = new QuadCollector();
        for (int i = 0; i < this.table.length; ++i) {
            result.table[i] = CompositeList.create(this.table[i], other.table[i]);
        }
        return result;
    }

    private static final class BlockRenderLayerIterable
    implements Iterable<BlockRenderLayer> {
        private BlockRenderLayerIterable() {
        }

        @Override
        public Iterator<BlockRenderLayer> iterator() {
            return new BlockRenderLayerIterator();
        }

        private static final class BlockRenderLayerIterator
        implements Iterator<BlockRenderLayer> {
            private static final BlockRenderLayer[] LAYERS = Arrays.copyOf(BlockRenderLayer.values(), BlockRenderLayer.values().length + 1);
            private int idx = 0;

            private BlockRenderLayerIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.idx < LAYERS.length;
            }

            @Override
            public BlockRenderLayer next() {
                return LAYERS[this.idx++];
            }
        }
    }
}

