/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.pipeline;

import com.enderio.core.common.util.NullHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.ITESRItemBlock;
import crazypants.enderio.base.render.model.CollectedItemQuadBakedBlockModel;
import crazypants.enderio.base.render.model.RelayingBakedModel;
import crazypants.enderio.base.render.pipeline.CacheKey;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.util.Prep;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class EnderItemOverrideList
extends ItemOverrideList {
    private static final Cache<Pair<Block, Long>, ItemQuadCollector> cache = CacheBuilder.newBuilder().maximumSize(500L).build();
    @Nonnull
    public static final EnderItemOverrideList instance = new EnderItemOverrideList();

    public EnderItemOverrideList() {
        super(Collections.emptyList());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void invalidate(@Nonnull ModelBakeEvent event) {
        cache.invalidateAll();
    }

    @Nonnull
    public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        IBlockState paintSource;
        if (Prep.isInvalid(stack)) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == Blocks.field_150350_a) {
            IModObject modObject = ModObjectRegistry.getModObject(stack.func_77973_b());
            if (modObject != null) {
                block = modObject.getBlock();
            }
            if (block == null || block == Blocks.field_150350_a) {
                throw new NullPointerException("Wrong parameter 'ItemStack stack', not an ItemBlock and not registered with ModObjectRegistry");
            }
        }
        if (block instanceof ITESRItemBlock) {
            return RelayingBakedModel.wrapModelForTESRRendering(originalModel);
        }
        if (!(!(block instanceof IPaintable.IBlockPaintableBlock) || block instanceof IPaintable.IWrenchHideablePaint && YetaUtil.shouldHeldItemHideFacadesClient() || (paintSource = ((IPaintable.IBlockPaintableBlock)block).getPaintSource(block, stack)) == null || paintSource == Blocks.field_150350_a.func_176223_P())) {
            Pair cacheKey = (Pair)NullHelper.notnull((Object)Pair.of((Object)null, (Object)new CacheKey().addCacheKey(paintSource).getCacheKey()), (String)"no way");
            ItemQuadCollector quads = (ItemQuadCollector)cache.getIfPresent((Object)cacheKey);
            if (quads == null) {
                quads = new ItemQuadCollector();
                quads.addItemBlockState(paintSource, Prep.getEmpty());
                quads.addBlockState(ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY)), Prep.getEmpty());
                cache.put((Object)cacheKey, (Object)quads);
            }
            return new CollectedItemQuadBakedBlockModel(originalModel, quads);
        }
        if (block instanceof ISmartRenderAwareBlock) {
            ItemQuadCollector quads;
            IRenderMapper.IItemRenderMapper renderMapper = ((ISmartRenderAwareBlock)block).getItemRenderMapper();
            Pair cacheKey = Pair.of((Object)block, (Object)renderMapper.getCacheKey(block, stack, new CacheKey().addCacheKey(stack.func_77960_j())).getCacheKey());
            ItemQuadCollector itemQuadCollector = quads = cacheKey.getRight() == null ? null : (ItemQuadCollector)cache.getIfPresent((Object)cacheKey);
            if (quads == null) {
                quads = new ItemQuadCollector();
                if (renderMapper instanceof IRenderMapper.IItemRenderMapper.IItemStateMapper) {
                    quads.addBlockStates(((IRenderMapper.IItemRenderMapper.IItemStateMapper)renderMapper).mapItemRender(block, stack, quads), stack, block);
                } else if (renderMapper instanceof IRenderMapper.IItemRenderMapper.IItemModelMapper) {
                    List<IBakedModel> bakedModels = ((IRenderMapper.IItemRenderMapper.IItemModelMapper)renderMapper).mapItemRender(block, stack);
                    if (bakedModels != null) {
                        for (IBakedModel bakedModel : bakedModels) {
                            quads.addItemBakedModel(bakedModel);
                        }
                    }
                } else {
                    return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
                }
                if (cacheKey.getRight() != null) {
                    cache.put((Object)cacheKey, (Object)quads);
                }
            }
            if (renderMapper instanceof IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper) {
                quads = quads.combine(((IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper)renderMapper).mapItemDynamicOverlayRender(block, stack));
            }
            return new CollectedItemQuadBakedBlockModel(originalModel, quads);
        }
        return originalModel;
    }
}

