/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.soul;

import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.soul.BasicSoulBinderRecipe;
import crazypants.enderio.util.CapturedMob;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DynamicSoulBinderRecipe
extends BasicSoulBinderRecipe {
    @Nonnull
    private final Predicate<ResourceLocation> entityFilter;

    public DynamicSoulBinderRecipe(@Nonnull ItemStack inputStack, @Nonnull ItemStack outputStack, int energyRequired, int xpRequired, @Nonnull String uid, @Nonnull RecipeLevel recipeLevel, @Nonnull Predicate<ResourceLocation> entityFilter, @Nonnull BasicSoulBinderRecipe.OutputFilter filter) {
        super(inputStack, outputStack, energyRequired, xpRequired, uid, recipeLevel, (NNList<ResourceLocation>)EntityUtil.getAllRegisteredMobNames(), filter);
        this.entityFilter = entityFilter;
    }

    @Override
    @Nonnull
    public NNList<ResourceLocation> getSupportedSouls() {
        return super.getSupportedSouls().stream().filter(this.entityFilter).collect(Collectors.toCollection(() -> new NNList()));
    }

    @Override
    protected boolean isValidInputSoul(@Nonnull CapturedMob mobType) {
        return super.getSupportedSouls().contains((Object)mobType.getEntityName()) && this.entityFilter.test(mobType.getEntityName());
    }
}

