/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.soul;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.soul.ISoulBinderRecipe;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractSoulBinderRecipe
implements ISoulBinderRecipe {
    private final int energyRequired;
    @Nonnull
    private final String uid;
    private final int xpLevelsRequired;
    @Nonnull
    private final RecipeLevel recipeLevel;
    @Nonnull
    private final NNList<ResourceLocation> supportedEntities;

    protected AbstractSoulBinderRecipe(int energyRequired, int xpLevelsRequired, @Nonnull String uid, @Nonnull RecipeLevel recipeLevel, @Nonnull Class<? extends Entity> entityClass) {
        this(energyRequired, xpLevelsRequired, uid, recipeLevel, EntityList.func_191306_a(entityClass));
    }

    protected AbstractSoulBinderRecipe(int energyRequired, int xpLevelsRequired, @Nonnull String uid, @Nonnull RecipeLevel recipeLevel, ResourceLocation ... entityNames) {
        this(energyRequired, xpLevelsRequired, uid, recipeLevel, (NNList<ResourceLocation>)new NNList((Object[])entityNames));
    }

    protected AbstractSoulBinderRecipe(int energyRequired, int xpLevelsRequired, @Nonnull String uid, @Nonnull RecipeLevel recipeLevel, @Nonnull NNList<ResourceLocation> entityNames) {
        this.energyRequired = energyRequired;
        this.xpLevelsRequired = xpLevelsRequired;
        this.uid = uid;
        this.supportedEntities = entityNames;
        this.recipeLevel = recipeLevel;
    }

    @Override
    @Nonnull
    public final String getUid() {
        return this.uid;
    }

    @Override
    public final int getExperienceLevelsRequired() {
        return this.xpLevelsRequired;
    }

    @Override
    public final int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        return this.getEnergyRequired();
    }

    @Override
    @Nonnull
    public final RecipeBonusType getBonusType(@Nonnull NNList<MachineRecipeInput> inputs) {
        return RecipeBonusType.NONE;
    }

    @Override
    public boolean isRecipe(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        int validCount = 0;
        for (MachineRecipeInput input : inputs) {
            if (input != null && this.isValidInput(machineLevel, input)) {
                ++validCount;
                continue;
            }
            return false;
        }
        return validCount == 2;
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        CapturedMob mobType = null;
        ItemStack inputItem = null;
        for (MachineRecipeInput input : inputs) {
            if (input != null && input.slotNumber == 0 && CapturedMob.containsSoul(input.item)) {
                mobType = CapturedMob.create(input.item);
                continue;
            }
            if (input == null || input.slotNumber != 1 || !this.isValidInputItem(input.item)) continue;
            inputItem = input.item;
        }
        if (mobType == null || !this.isValidInputSoul(mobType) || inputItem == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack resultStack = this.getOutputStack(inputItem, mobType);
        ItemStack soulVessel = new ItemStack(ModObject.itemSoulVial.getItemNN());
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(soulVessel), new IMachineRecipe.ResultStack(resultStack)};
    }

    @Override
    public final float getExperienceForOutput(@Nonnull ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput input) {
        if (!this.recipeLevel.canMake(machineLevel)) {
            return false;
        }
        if (Prep.isInvalid(input.item)) {
            return false;
        }
        int slot = input.slotNumber;
        ItemStack item = input.item;
        if (slot == 0) {
            CapturedMob mobType = CapturedMob.create(item);
            return mobType != null && item.func_77973_b() == ModObject.itemSoulVial.getItemNN() && this.isValidInputSoul(mobType);
        }
        if (slot == 1) {
            return this.isValidInputItem(item);
        }
        return false;
    }

    protected boolean isValidInputSoul(@Nonnull CapturedMob mobType) {
        return this.getSupportedSouls().contains((Object)mobType.getEntityName());
    }

    protected boolean isValidInputItem(@Nonnull ItemStack item) {
        return item.func_77969_a(this.getInputStack());
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "soulbinder";
    }

    @Override
    @Nonnull
    public List<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>(inputs.size());
        for (MachineRecipeInput input : inputs) {
            if (input == null || !Prep.isValid(input.item)) continue;
            ItemStack resStack = input.item.func_77946_l();
            resStack.func_190920_e(1);
            MachineRecipeInput mri = new MachineRecipeInput(input.slotNumber, resStack);
            result.add(mri);
        }
        return result;
    }

    @Override
    @Nonnull
    public NNList<ResourceLocation> getSupportedSouls() {
        return this.supportedEntities;
    }

    @Override
    public final int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    @Nonnull
    public RecipeLevel getRecipeLevel() {
        return this.recipeLevel;
    }
}

