/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.lookup;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.recipe.lookup.IRecipeNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class RecipeLeafNode<REC, LOB, LID>
implements IRecipeNode<REC, LOB, LID> {
    @Nonnull
    private final Function<LOB, LID> toId;
    @Nonnull
    private final Map<LID, NNList<REC>> map = new HashMap<LID, NNList<REC>>();

    public RecipeLeafNode(@Nonnull Function<LOB, LID> toId) {
        this.toId = toId;
    }

    @Override
    @Nonnull
    public NNList<REC> getRecipes(@Nonnull LOB key) {
        return (NNList)NullHelper.first(this.map.get(this.toId.apply(key)), (Supplier[])new Supplier[]{NNList::emptyList});
    }

    public void addRecipe(@Nonnull REC recipe, @Nonnull LOB key) {
        NNList recipes = this.map.computeIfAbsent(this.toId.apply(key), unused -> new NNList());
        if (!recipes.contains(recipe)) {
            recipes.add(recipe);
        }
    }
}

