/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.RecipeInput;
import crazypants.enderio.util.Prep;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.xml.sax.Attributes;

public class RecipeConfigParser {
    @Nonnull
    public static final String AT_ORE_DICT = "oreDictionary";
    @Nonnull
    public static final String AT_ITEM_META = "itemMeta";
    @Nonnull
    public static final String AT_ITEM_NAME = "itemName";
    @Nonnull
    public static final String AT_MOD_ID = "modID";
    @Nonnull
    public static final String AT_NUMBER = "number";
    @Nonnull
    public static final String AT_MULTIPLIER = "multiplier";
    @Nonnull
    public static final String AT_SLOT = "slot";
    @Nonnull
    private static final String LP = "RecipeParser: ";

    public static RecipeInput getItemStack(Attributes attributes) {
        int stackSize = RecipeConfigParser.getIntValue(AT_NUMBER, attributes, 1);
        boolean useMeta = true;
        int itemMeta = 0;
        String metaString = RecipeConfigParser.getStringValue(AT_ITEM_META, attributes, "0");
        if ("*".equals(metaString)) {
            useMeta = false;
        } else {
            itemMeta = RecipeConfigParser.getIntValue(AT_ITEM_META, attributes, 0);
        }
        ItemStack res = Prep.getEmpty();
        String modId = RecipeConfigParser.getStringValue(AT_MOD_ID, attributes, null);
        String name = RecipeConfigParser.getStringValue(AT_ITEM_NAME, attributes, null);
        if (modId != null && name != null) {
            ResourceLocation rl = new ResourceLocation(modId, name);
            Item i = (Item)Item.field_150901_e.func_82594_a((Object)rl);
            if (i != null) {
                res = new ItemStack(i, stackSize, useMeta ? itemMeta : 0);
            } else if (Block.field_149771_c.func_148741_d((Object)rl)) {
                Block b = (Block)Block.field_149771_c.func_82594_a((Object)rl);
                res = new ItemStack(b, stackSize, useMeta ? itemMeta : 0);
            }
        }
        if (Prep.isInvalid(res)) {
            Log.debug("Could not create an item stack from the attributes " + RecipeConfigParser.toString(attributes));
            return null;
        }
        return new RecipeInput(res, useMeta, RecipeConfigParser.getFloatValue(AT_MULTIPLIER, attributes, 1.0f), RecipeConfigParser.getIntValue(AT_SLOT, attributes, -1));
    }

    public static boolean getBooleanValue(String qName, Attributes attributes, boolean def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        return (val = val.toLowerCase(Locale.US).trim()).equals("false") ? false : (val.equals("true") ? true : def);
    }

    public static int getIntValue(String qName, Attributes attributes, int def) {
        try {
            return Integer.parseInt(RecipeConfigParser.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("RecipeParser: Could not parse a valid int for attribute " + qName + " with value " + RecipeConfigParser.getStringValue(qName, attributes, null));
            return def;
        }
    }

    public static float getFloatValue(String qName, Attributes attributes, float def) {
        try {
            return Float.parseFloat(RecipeConfigParser.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("RecipeParser: Could not parse a valid float for attribute " + qName + " with value " + RecipeConfigParser.getStringValue(qName, attributes, null));
            return def;
        }
    }

    public static String getStringValue(String qName, Attributes attributes, String def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        if ((val = val.trim()).length() <= 0) {
            return null;
        }
        return val;
    }

    public static String toString(Attributes attributes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append("[" + attributes.getQName(i) + "=" + attributes.getValue(i) + "]");
        }
        return sb.toString();
    }
}

