/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.glass;

import com.enderio.core.common.fluid.SmartTank;
import crazypants.enderio.base.fluid.ItemTankHelper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.base.render.util.HalfBakedQuad;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.base.render.util.TankRenderHelper;
import crazypants.enderio.util.NbtValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class FusedQuartzItemRenderMapper
implements IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper,
IRenderMapper.IItemRenderMapper.IItemStateMapper {
    @Nonnull
    public static final FusedQuartzItemRenderMapper instance = new FusedQuartzItemRenderMapper();

    protected FusedQuartzItemRenderMapper() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ItemQuadCollector itemQuadCollector) {
        if (NbtValue.FAKE.hasTag(stack)) {
            return null;
        }
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        IBlockState defaultState = block.func_176223_P();
        states.add(Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.sides)), (Object)null));
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.UP))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, EnumFacing.DOWN))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f()))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.UP))), (Object)null));
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)defaultState.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.get(facing, facing.func_176735_f(), EnumFacing.DOWN))), (Object)null));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemQuadCollector mapItemDynamicOverlayRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        SmartTank tank;
        HalfBakedQuad.HalfBakedList buffer;
        if (NbtValue.FAKE.hasTag(stack) && (buffer = TankRenderHelper.mkTank(tank = ItemTankHelper.getTank(stack), 0.0, 0.0, 16.0, true)) != null) {
            ItemQuadCollector result = new ItemQuadCollector();
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            buffer.bake(quads);
            result.addQuads(null, quads);
            return result;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        if (NbtValue.FAKE.hasTag(stack)) {
            cacheKey.addCacheKey(2146898743);
        }
        return cacheKey;
    }
}

