/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import crazypants.enderio.base.potion.PotionUtil;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class Potion
extends LootFunction {
    @Nonnull
    private final ResourceLocation name;
    private final boolean splash;

    public Potion(LootCondition[] conditionsIn, @Nonnull String name, boolean splash) {
        super(conditionsIn);
        this.name = new ResourceLocation(name);
        this.splash = splash;
        if (!PotionType.field_185176_a.func_148741_d((Object)this.name)) {
            throw new RuntimeException(name + " is not a valid potion type");
        }
    }

    @Nonnull
    public ItemStack func_186553_a(@Nonnull ItemStack stack, @Nonnull Random rand, @Nonnull LootContext context) {
        PotionType type = (PotionType)PotionType.field_185176_a.func_82594_a((Object)this.name);
        ItemStack potion = PotionUtil.getEmptyPotion(this.splash);
        PotionUtils.func_185188_a((ItemStack)potion, (PotionType)type);
        return potion;
    }

    public static class Serializer
    extends LootFunction.Serializer<Potion> {
        protected Serializer() {
            super(new ResourceLocation("enderio", "potion"), Potion.class);
        }

        public void serialize(@Nonnull JsonObject object, @Nonnull Potion functionClazz, @Nonnull JsonSerializationContext serializationContext) {
            object.addProperty("name", functionClazz.name.toString());
            object.addProperty("splash", Boolean.valueOf(functionClazz.splash));
        }

        @Nonnull
        public Potion deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull LootCondition[] conditionsIn) {
            return new Potion(conditionsIn, JsonUtils.func_151200_h((JsonObject)object, (String)"name"), JsonUtils.func_151212_i((JsonObject)object, (String)"splash"));
        }
    }
}

