/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.loot.LootSelector;
import crazypants.enderio.base.loot.WeightedUpgrade;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enderio")
public class AnvilCapacitorRecipe {
    @SubscribeEvent
    public static void handleAnvilEvent(AnvilUpdateEvent evt) {
        WeightedUpgrade weightedUpgrade;
        ItemStack left = evt.getLeft();
        ItemStack right = evt.getRight();
        if (!((Boolean)RecipeConfig.enableLootCapCombining.get()).booleanValue() || Prep.isInvalid(left) || Prep.isInvalid(right) || left.func_77973_b() != ModObject.itemBasicCapacitor.getItemNN() || left.func_77973_b() != right.func_77973_b() || left.func_77960_j() < 3 || right.func_77960_j() < 3 || ((Boolean)RecipeConfig.requireSameType.get()).booleanValue() && left.func_77960_j() != right.func_77960_j() || left.func_190916_E() > right.func_190916_E()) {
            return;
        }
        List<Pair<String, Float>> dataLeft = CapacitorHelper.getCapDataRaw(left);
        List<Pair<String, Float>> dataRight = CapacitorHelper.getCapDataRaw(right);
        if (dataLeft == null || dataRight == null || dataLeft.isEmpty() || dataRight.isEmpty()) {
            return;
        }
        HashMap<WeightedUpgrade, Pair> data = new HashMap<WeightedUpgrade, Pair>();
        float seed = 0.0f;
        for (Pair<String, Float> pair : dataLeft) {
            weightedUpgrade = WeightedUpgrade.getByRawString((String)pair.getKey());
            if (weightedUpgrade == null) {
                return;
            }
            data.put(weightedUpgrade, Pair.of((Object)pair.getValue(), (Object)null));
            seed += ((Float)pair.getValue()).floatValue();
        }
        for (Pair<String, Float> pair : dataRight) {
            weightedUpgrade = WeightedUpgrade.getByRawString((String)pair.getKey());
            if (weightedUpgrade == null) {
                return;
            }
            if (data.containsKey(weightedUpgrade)) {
                data.put(weightedUpgrade, Pair.of((Object)pair.getValue(), (Object)((Pair)data.get(weightedUpgrade)).getKey()));
            } else {
                data.put(weightedUpgrade, Pair.of((Object)pair.getValue(), (Object)null));
            }
            seed += ((Float)pair.getValue()).floatValue();
        }
        Random rand = new Random((long)(seed * 1000.0f));
        HashMap<WeightedUpgrade, Float> result = new HashMap<WeightedUpgrade, Float>();
        for (WeightedUpgrade.WeightedUpgradeImpl wai : WeightedUpgrade.getWeightedupgrades()) {
            WeightedUpgrade wa = wai.getUpgrade();
            if (!data.containsKey(wa)) continue;
            float combine = AnvilCapacitorRecipe.combine(rand, (Pair<Float, Float>)((Pair)data.get(wa)));
            result.put(wa, Float.valueOf(combine));
            Log.debug("Combining " + wa + " " + ((Pair)data.get(wa)).getKey() + " and " + ((Pair)data.get(wa)).getValue() + " to " + combine);
        }
        float baselevel = Math.max(CapacitorHelper.getCapLevelRaw(left), CapacitorHelper.getCapLevelRaw(right));
        if (baselevel < ((Float)RecipeConfig.baseLevelIncrementMax.get()).floatValue() - ((Float)RecipeConfig.baseLevelIncrement.get()).floatValue() && rand.nextFloat() <= ((Float)RecipeConfig.baseLevelIncrementChance.get()).floatValue()) {
            baselevel += ((Float)RecipeConfig.baseLevelIncrement.get()).floatValue();
        }
        ItemStack stack = left.func_77946_l();
        String name = LootSelector.buildBaseName(EnderIO.lang.localize("loot.capacitor.name"), baselevel);
        stack = CapacitorHelper.addCapData(stack, CapacitorHelper.SetType.LEVEL, null, baselevel);
        for (Map.Entry entry : result.entrySet()) {
            stack = CapacitorHelper.addCapData(stack, ((WeightedUpgrade)entry.getKey()).setType, ((WeightedUpgrade)entry.getKey()).capacitorKey, ((Float)entry.getValue()).floatValue());
            name = LootSelector.buildName(EnderIO.lang.localize(((WeightedUpgrade)entry.getKey()).langKey, new Object[]{name}), ((Float)entry.getValue()).floatValue());
        }
        NbtValue.CAPNAME.setString(stack, name);
        evt.setOutput(stack);
        evt.setMaterialCost(stack.func_190916_E());
        evt.setCost((int)(baselevel * baselevel * ((Float)RecipeConfig.levelCostFactor.get()).floatValue()) * stack.func_190916_E());
    }

    private static float combine(Random rand, Pair<Float, Float> pair) {
        if (pair.getRight() == null) {
            return ((Float)pair.getLeft()).floatValue();
        }
        return AnvilCapacitorRecipe.combine(rand, ((Float)pair.getLeft()).floatValue(), ((Float)pair.getRight()).floatValue());
    }

    private static float combine(Random rand, float a, float b) {
        float min = a < b ? a : b;
        float center = a < b ? b : a;
        float offsetLow = Math.max(center - min, ((Float)RecipeConfig.specialityLevelMin.get()).floatValue());
        float max = Math.min(center + offsetLow, ((Float)RecipeConfig.specialityLevelMax.get()).floatValue());
        float offsetHigh = max - center;
        float gaussian = (float)rand.nextGaussian() + ((Float)RecipeConfig.specialityLevelBias.get()).floatValue();
        if (gaussian <= 0.0f) {
            return Math.max(min, center + gaussian * offsetLow);
        }
        return Math.min(max, center + gaussian * offsetHigh);
    }
}

