/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.rodofreturn;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.ClientUtil;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.CompoundCapabilityProvider;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.config.ItemConfig;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.sound.MachineSound;
import crazypants.enderio.base.power.forge.item.AbstractPoweredItem;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.base.teleport.TeleportUtil;
import crazypants.enderio.util.NbtValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRodOfReturn
extends AbstractPoweredItem
implements IAdvancedTooltipProvider,
IOverlayRenderAware {
    private static final int RF_MAX_INPUT = (int)Math.ceil((double)((Integer)ItemConfig.rodOfReturnPowerStorage.get()).intValue() / (double)((Integer)ItemConfig.rodOfReturnMinTicksToRecharge.get()).intValue());
    @Nonnull
    public static final ResourceLocation ACTIVE_RES = new ResourceLocation("enderio", "telepad.active");
    @SideOnly(value=Side.CLIENT)
    private MachineSound activeSound;

    public static ItemRodOfReturn create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemRodOfReturn(modObject);
    }

    protected ItemRodOfReturn(@Nonnull IModObject modObject) {
        super((Integer)ItemConfig.rodOfReturnPowerStorage.get(), RF_MAX_INPUT, 0);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        ITelePad tp;
        if (world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITelePad && (tp = ((ITelePad)te).getMaster()) != null) {
            pos = tp.getLocation();
            this.setTarget(stack, pos, world.field_73011_w.getDimension());
            player.func_145747_a((ITextComponent)Lang.RETURN_ROD_SYNC_TELEPAD.toChat(BlockCoord.chatString((BlockPos)pos, (TextFormatting)TextFormatting.WHITE)));
            player.func_184597_cx();
            return EnumActionResult.SUCCESS;
        }
        if (((Boolean)ItemConfig.rodOfReturnCanTargetAnywhere.get()).booleanValue()) {
            this.setTarget(stack, pos, world.field_73011_w.getDimension());
            player.func_145747_a((ITextComponent)Lang.RETURN_ROD_SYNC.toChat(BlockCoord.chatString((BlockPos)pos, (TextFormatting)TextFormatting.WHITE)));
            player.func_184597_cx();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        long lastUsed = NbtValue.LAST_USED_TICK.getLong(stack);
        if ((lastUsed < 0L || world.func_82737_E() - lastUsed > 20L) && this.getEnergyStored(stack) > 0) {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(@Nonnull ItemStack stack, @Nonnull EntityLivingBase player, int count) {
        if (player.field_70170_p.field_72995_K) {
            this.onUsingClient(stack, player, count);
        }
        int used = ((Integer)ItemConfig.rodOfReturnTicksToActivate.get() - count) * 1000;
        int newVal = this.getEnergyStored(stack) - used;
        if (newVal < 0) {
            if (player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)Lang.RETURN_ROD_NO_POWER.toChat(TextFormatting.RED));
            }
            player.func_184597_cx();
        }
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase player, int timeLeft) {
        if (!(player instanceof EntityPlayer) || !((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            this.updateStackNBT(stack, world, timeLeft);
        }
        if (world.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase entityLiving) {
        boolean hasPower = true;
        boolean hasFluid = true;
        if (!(entityLiving instanceof EntityPlayer) || !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
            hasPower = this.updateStackNBT(stack, worldIn, 0);
            boolean bl = hasFluid = hasPower ? this.useFluid(stack) : true;
        }
        if (hasPower && hasFluid) {
            TelepadTarget target = TelepadTarget.readFromNBT(stack);
            if (target == null) {
                if (worldIn.field_72995_K) {
                    this.stopPlayingSound();
                    entityLiving.func_145747_a((ITextComponent)Lang.RETURN_ROD_NO_TARGET.toChat(TextFormatting.RED));
                }
                return stack;
            }
            TeleportUtil.doTeleport((Entity)entityLiving, target.getLocation(), target.getDimension(), false, TravelSource.TELEPAD);
        } else if (worldIn.field_72995_K) {
            if (!hasPower) {
                entityLiving.func_145747_a((ITextComponent)Lang.RETURN_ROD_NO_POWER.toChat(TextFormatting.RED));
            } else {
                entityLiving.func_145747_a((ITextComponent)Lang.RETURN_ROD_NO_FLUID.toChat(TextFormatting.RED));
            }
        }
        if (worldIn.field_72995_K) {
            this.stopPlayingSound();
        }
        return stack;
    }

    public boolean canDestroyBlockInCreative(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldS, @Nonnull ItemStack newS, boolean slotChanged) {
        return slotChanged || oldS.func_77973_b() != newS.func_77973_b();
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return true;
    }

    public void func_77622_d(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull EntityPlayer entityPlayer) {
        this.setEnergyStored(itemStack, 0);
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return (Integer)ItemConfig.rodOfReturnTicksToActivate.get();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ItemRodOfReturn.usesFluid()) {
            tooltip.add(Lang.RETURN_ROD_FLUID.get(LangFluid.MB(NbtValue.FLUIDAMOUNT.getInt(stack, 0), (int)((Integer)ItemConfig.rodOfReturnFluidStorage.get()))));
        }
        tooltip.add(Lang.RETURN_ROD_POWER.get(LangPower.RF(this.getEnergyStored(stack), (Integer)ItemConfig.rodOfReturnPowerStorage.get())));
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            this.setFull(is);
            list.add((Object)is);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition, true);
        if (ItemRodOfReturn.usesFluid()) {
            PowerBarOverlayRenderHelper.instance_fluid.render(stack, xPosition, yPosition, 1, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onUsingClient(ItemStack stack, EntityLivingBase player, int timeLeft) {
        if (timeLeft > (Integer)ItemConfig.rodOfReturnTicksToActivate.get() - 2) {
            return;
        }
        float progress = 1.0f - (float)timeLeft / (float)((Integer)ItemConfig.rodOfReturnTicksToActivate.get()).intValue();
        float spinSpeed = progress * 2.0f;
        if (this.activeSound != null) {
            this.activeSound.setPitch(MathHelper.func_76131_a((float)(0.5f + spinSpeed / 1.5f), (float)0.5f, (float)2.0f));
        }
        if (this.activeSound == null) {
            BlockPos p = player.func_180425_c();
            this.activeSound = new MachineSound(ACTIVE_RES, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), 0.3f, 1.0f);
            this.playSound();
        }
        double dist = 2.0 - (double)progress * 1.5;
        Random rand = player.field_70170_p.field_73012_v;
        for (int i = 0; i < 6; ++i) {
            double xo = this.randomOffset(rand, dist);
            double yo = this.randomOffset(rand, dist);
            double zo = this.randomOffset(rand, dist);
            double x = player.field_70165_t + xo;
            double y = player.field_70163_u + yo + (double)(player.field_70131_O / 2.0f);
            double z = player.field_70161_v + zo;
            Vector3d velocity = new Vector3d(xo, yo, zo);
            velocity.normalize();
            Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.PORTAL.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[]{0});
            if (fx == null) continue;
            ClientUtil.setParticleVelocity((Particle)fx, (double)velocity.x, (double)velocity.y, (double)velocity.z);
            fx.func_187114_a(timeLeft + 2);
        }
    }

    private double randomOffset(Random rand, double magnitude) {
        return (rand.nextDouble() - 0.5) * magnitude;
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound() {
        MachineSound activeSound_nullchecked = this.activeSound;
        if (activeSound_nullchecked != null) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)activeSound_nullchecked);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopPlayingSound() {
        if (this.activeSound != null) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    private boolean updateStackNBT(@Nonnull ItemStack stack, @Nonnull World world, int timeLeft) {
        NbtValue.LAST_USED_TICK.setLong(stack, world.func_82737_E());
        if (timeLeft > (Integer)ItemConfig.rodOfReturnTicksToActivate.get() - 10) {
            return false;
        }
        return this.useEnergy(stack, timeLeft);
    }

    private boolean useEnergy(@Nonnull ItemStack stack, int timeLeft) {
        int used = ((Integer)ItemConfig.rodOfReturnTicksToActivate.get() - timeLeft) * (Integer)ItemConfig.rodOfReturnRfPerTick.get();
        int newVal = this.getEnergyStored(stack) - used;
        if (newVal < 0) {
            this.setEnergyStored(stack, 0);
            return false;
        }
        this.setEnergyStored(stack, newVal);
        return true;
    }

    @Override
    public void setFull(@Nonnull ItemStack container) {
        super.setFull(container);
        if (ItemRodOfReturn.usesFluid()) {
            NbtValue.FLUIDAMOUNT.setInt(container, (int)((Integer)ItemConfig.rodOfReturnFluidStorage.get()));
        }
    }

    private void setTarget(@Nonnull ItemStack container, @Nonnull BlockPos pos, int dimension) {
        new TelepadTarget(pos, dimension).writeToNBT(container);
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.func_77658_a());
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)this.func_77658_a());
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        ArrayList entries = new ArrayList();
        SpecialTooltipHandler.addDetailedTooltipFromResources(entries, (String)this.func_77658_a());
        String fluidString = ItemRodOfReturn.usesFluid() ? ((Fluid)ItemConfig.rodOfReturnFluidType.get()).getLocalizedName(new FluidStack((Fluid)ItemConfig.rodOfReturnFluidType.get(), 1000)) : "---";
        for (int i = 0; i < entries.size(); ++i) {
            String str = (String)entries.get(i);
            list.add(String.format(str, fluidString));
        }
    }

    private boolean useFluid(@Nonnull ItemStack container) {
        if (!ItemRodOfReturn.usesFluid()) {
            return true;
        }
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if ((Integer)ItemConfig.rodOfReturnFluidUsePerTeleport.get() > amount) {
            NbtValue.FLUIDAMOUNT.setInt(container, 0);
            return false;
        }
        NbtValue.FLUIDAMOUNT.setInt(container, amount - (Integer)ItemConfig.rodOfReturnFluidUsePerTeleport.get());
        return true;
    }

    public FluidStack getFluid(@Nonnull ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (amount > 0 && ItemRodOfReturn.usesFluid()) {
            return new FluidStack((Fluid)ItemConfig.rodOfReturnFluidType.get(), amount);
        }
        return null;
    }

    public int fill(@Nonnull ItemStack container, @Nonnull FluidStack resource, boolean doFill) {
        if (container.func_77973_b() != this || resource.amount <= 0 || resource.getFluid() == null || resource.getFluid() != ItemConfig.rodOfReturnFluidType.get() || !ItemRodOfReturn.usesFluid()) {
            return 0;
        }
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        int capacity = (Integer)ItemConfig.rodOfReturnFluidStorage.get();
        int free = capacity - amount;
        int toFill = Math.min(resource.amount, free);
        if (toFill > 0 && doFill) {
            NbtValue.FLUIDAMOUNT.setInt(container, amount + toFill);
        }
        return toFill;
    }

    private static boolean usesFluid() {
        return (Integer)ItemConfig.rodOfReturnFluidUsePerTeleport.get() > 0;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CompoundCapabilityProvider(new ICapabilityProvider[]{new FluidCapabilityProvider(stack), super.initCapabilities(stack, nbt)});
    }

    private final class FluidCapabilityProvider
    implements IFluidHandlerItem,
    ICapabilityProvider {
        @Nonnull
        protected final ItemStack container;

        private FluidCapabilityProvider(ItemStack container) {
            this.container = container;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == FluidUtil.getFluidItemCapability();
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == FluidUtil.getFluidItemCapability() ? this : null);
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ItemRodOfReturn.this.getFluid(FluidCapabilityProvider.this.container);
                }

                public int getCapacity() {
                    return (Integer)ItemConfig.rodOfReturnFluidStorage.get();
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack != null && fluidStack.getFluid() == ItemConfig.rodOfReturnFluidType.get();
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ItemRodOfReturn.this.fill(this.container, (FluidStack)NullHelper.notnull((Object)resource, (String)"Cannot use null as a fluid stack"), doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }
    }
}

