/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.autosave.BaseHandlers;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.integration.jei.IHaveGhostTargets;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

@Storable
public class EnchantmentFilter
implements IItemFilter.WithGhostSlots {
    public static final int GUI_ROWS = 5;
    @Store
    @Nonnull
    private final NNList<Enchantment> enchantments = new NNList();
    @Store
    private boolean blacklist = false;
    @Store
    private boolean sticky = false;
    @Store
    private int slotCount = 9;

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getSlotCount() {
        return this.slotCount;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(boolean blacklist) {
        this.blacklist = blacklist;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public void setSlotCount(int slotCount) {
        this.slotCount = slotCount;
    }

    public NNList<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        Reader.read((Registry)BaseHandlers.REGISTRY, (NBTTagCompound)nbtRoot, (Object)this);
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        Writer.write((Registry)BaseHandlers.REGISTRY, (NBTTagCompound)nbtRoot, (Object)this);
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)tag, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        this.readFromNBT(NetworkUtil.readNBTTagCompound((ByteBuf)buf));
    }

    @Override
    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    @Override
    public boolean doesItemPassFilter(@Nullable IItemHandler inv, @Nonnull ItemStack item) {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)item);
        if (!map.isEmpty()) {
            if (this.isEmpty()) {
                return !this.blacklist;
            }
            for (Enchantment enchantment : this.enchantments) {
                if (!map.containsKey(enchantment)) continue;
                return !this.blacklist;
            }
        }
        return this.blacklist;
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack stack) {
        Set set = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet();
        if (!set.isEmpty()) {
            block0: for (Enchantment input : set) {
                for (Enchantment existing : this.enchantments) {
                    if (existing != input) continue;
                    continue block0;
                }
                if (slot < this.enchantments.size()) {
                    this.enchantments.set(slot, (Object)input);
                } else {
                    this.enchantments.add((Object)input);
                }
                slot = Integer.MAX_VALUE;
            }
            while (this.enchantments.size() > this.slotCount) {
                this.enchantments.remove(this.slotCount);
            }
        } else if (slot < this.enchantments.size()) {
            this.enchantments.remove(slot);
        }
    }

    public void setEnchantment(int slot, @Nonnull Enchantment enchantment) {
        if (!this.enchantments.contains((Object)enchantment)) {
            if (slot < this.enchantments.size()) {
                this.enchantments.set(slot, (Object)enchantment);
            } else {
                this.enchantments.add((Object)enchantment);
            }
            while (this.enchantments.size() > this.slotCount) {
                this.enchantments.remove(this.slotCount);
            }
        } else if (slot < this.enchantments.size()) {
            this.enchantments.remove(slot);
        }
    }

    @Override
    @Nonnull
    public ItemStack getInventorySlotContents(int slot) {
        if (slot < this.enchantments.size()) {
            EnchantmentData enchantmentData = new EnchantmentData((Enchantment)this.enchantments.get(slot), 1);
            ItemStack output = new ItemStack(Items.field_151134_bR);
            ItemEnchantedBook.func_92115_a((ItemStack)output, (EnchantmentData)enchantmentData);
            return output;
        }
        return Prep.getEmpty();
    }

    @Override
    public void createGhostSlots(@Nonnull NNList<GhostSlot> slots, int xOffset, int yOffset, @Nullable Runnable cb) {
        int row = 0;
        int col = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            int x = xOffset + col * 81;
            int y = yOffset + row * 18;
            slots.add((Object)new EnchantmentFilterGhostSlot(i, x, y, cb));
            if (++row < 5) continue;
            row = 0;
            ++col;
        }
    }

    public class EnchantmentFilterGhostSlot
    extends GhostSlot
    implements IHaveGhostTargets.IEnchantmentGhostSlot {
        private final Runnable cb;

        EnchantmentFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.setX(x);
            this.setY(y);
            this.setSlot(slot);
            this.cb = cb;
            this.setDisplayStdOverlay(false);
            this.setStackSizeLimit(1);
        }

        public void putStack(@Nonnull ItemStack stack, int realsize) {
            EnchantmentFilter.this.setInventorySlotContents(this.getSlot(), stack);
            this.cb.run();
        }

        @Nonnull
        public ItemStack getStack() {
            return EnchantmentFilter.this.getInventorySlotContents(this.getSlot());
        }

        @Override
        public void putEnchantment(@Nonnull Enchantment enchantment) {
            EnchantmentFilter.this.setEnchantment(this.getSlot(), enchantment);
            this.cb.run();
        }
    }
}

