/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.geom;

import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.Offset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;

public class CollidableCache {
    public static final CollidableCache instance = new CollidableCache();
    private final Map<CacheKey, Collection<CollidableComponent>> cache = new HashMap<CacheKey, Collection<CollidableComponent>>();

    @Nonnull
    public CacheKey createKey(@Nonnull Class<? extends IConduit> baseType, @Nonnull Offset offset, @Nullable EnumFacing dir) {
        return new CacheKey(baseType, offset, dir);
    }

    public Collection<CollidableComponent> getCollidables(@Nonnull CacheKey key, @Nonnull IConduit conduit) {
        Collection<CollidableComponent> result = this.cache.get(key);
        if (result == null) {
            result = conduit.createCollidables(key);
            this.cache.put(key, result);
        }
        return result;
    }

    public static class CacheKey {
        @Nonnull
        public final Class<? extends IConduit> baseType;
        @Nonnull
        public final String className;
        @Nonnull
        public final Offset offset;
        @Nullable
        public final EnumFacing dir;

        public CacheKey(@Nonnull Class<? extends IConduit> baseType, @Nonnull Offset offset, @Nullable EnumFacing dir) {
            this.baseType = baseType;
            this.className = baseType.getCanonicalName();
            this.offset = offset;
            this.dir = dir;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.className.hashCode();
            result = 31 * result + (this.dir != null ? this.dir.hashCode() : 0);
            result = 31 * result + this.offset.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!this.className.equals(other.className)) {
                return false;
            }
            if (this.dir != other.dir) {
                return false;
            }
            return this.offset == other.offset;
        }
    }
}

