/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.util.NbtValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ConduitDisplayMode {
    @Nonnull
    public static final ConduitDisplayMode NEUTRAL = new ConduitDisplayMode("neutral", (IWidgetIcon)IconEIO.YETA_GEAR, (IWidgetIcon)IconEIO.YETA_GEAR);
    @Nonnull
    public static final ConduitDisplayMode ALL = new ConduitDisplayMode("all", (IWidgetIcon)IconEIO.TICK, (IWidgetIcon)IconEIO.TICK);
    @Nonnull
    public static final ConduitDisplayMode NONE = new ConduitDisplayMode("none", (IWidgetIcon)IconEIO.CROSS, (IWidgetIcon)IconEIO.CROSS);
    @Nonnull
    private static final NNList<ConduitDisplayMode> registrar = new NNList();
    @Nonnull
    private final Class<? extends IConduit> conduitType;
    @Nonnull
    private final IWidgetIcon widgetSelected;
    @Nonnull
    private final IWidgetIcon widgetUnselected;
    @Nullable
    private String overrideName = null;

    public static void registerDisplayMode(@Nonnull ConduitDisplayMode mode) {
        if (!registrar.contains((Object)mode)) {
            registrar.add((Object)mode);
        }
    }

    public ConduitDisplayMode(@Nonnull String name, @Nonnull IWidgetIcon widgetSelected, @Nonnull IWidgetIcon widgetUnselected) {
        this(IConduit.class, widgetSelected, widgetUnselected);
        this.setName(name);
    }

    public ConduitDisplayMode(@Nonnull Class<? extends IConduit> conduitType, @Nonnull IWidgetIcon widgetSelected, @Nonnull IWidgetIcon widgetUnselected) {
        this.conduitType = conduitType;
        this.widgetSelected = widgetSelected;
        this.widgetUnselected = widgetUnselected;
    }

    @Nonnull
    public Class<? extends IConduit> getConduitType() {
        return this.conduitType;
    }

    public boolean renderConduit(@Nullable Class<? extends IConduit> conduitTypeIn) {
        if (this == ALL || this == NEUTRAL || conduitTypeIn == null) {
            return true;
        }
        if (this == NONE) {
            return false;
        }
        return this.conduitType.isAssignableFrom(conduitTypeIn);
    }

    @Nonnull
    public String getName() {
        return this.overrideName == null ? this.conduitType.getSimpleName() : this.overrideName;
    }

    public void setName(@Nonnull String name) {
        this.overrideName = name;
    }

    @Nonnull
    public IWidgetIcon getWidgetSelected() {
        return this.widgetSelected;
    }

    @Nonnull
    public IWidgetIcon getWidgetUnselected() {
        return this.widgetUnselected;
    }

    @Nonnull
    public static ConduitDisplayMode next(@Nonnull ConduitDisplayMode mode) {
        return (ConduitDisplayMode)registrar.next((Object)mode);
    }

    @Nonnull
    public static ConduitDisplayMode previous(@Nonnull ConduitDisplayMode mode) {
        return (ConduitDisplayMode)registrar.prev((Object)mode);
    }

    @Nullable
    public static ConduitDisplayMode fromName(String name) {
        for (ConduitDisplayMode mode : registrar) {
            if (!mode.getName().equals(name)) continue;
            return mode;
        }
        return null;
    }

    public int ordinal() {
        return registrar.indexOf((Object)this);
    }

    @Nonnull
    public static ConduitDisplayMode getDisplayMode(@Nonnull ItemStack equipped) {
        if (!(equipped.func_77973_b() instanceof IConduitControl)) {
            return ALL;
        }
        ConduitDisplayMode mode = ConduitDisplayMode.fromName(NbtValue.DISPLAYMODE.getString(equipped, ALL.getName()));
        if (mode == null) {
            ConduitDisplayMode.setDisplayMode(equipped, ALL);
            return ALL;
        }
        return mode;
    }

    public static void setDisplayMode(@Nonnull ItemStack equipped, @Nonnull ConduitDisplayMode mode) {
        if (!(equipped.func_77973_b() instanceof IConduitControl)) {
            return;
        }
        NbtValue.DISPLAYMODE.setString(equipped, mode.getName());
    }

    @Nonnull
    public ConduitDisplayMode next() {
        return ConduitDisplayMode.next(this);
    }

    @Nonnull
    public ConduitDisplayMode previous() {
        return ConduitDisplayMode.previous(this);
    }

    public boolean isAll() {
        return this == ALL || this == NEUTRAL;
    }

    public static int registrySize() {
        return registrar.size() - 2;
    }

    public static Iterable<ConduitDisplayMode> getRenderableModes() {
        return FluentIterable.from(registrar).filter((Predicate)new Predicate<ConduitDisplayMode>(){

            public boolean apply(@Nullable ConduitDisplayMode input) {
                return input != ALL && input != NONE;
            }

            public boolean equals(@Nullable Object obj) {
                return super.equals(obj);
            }

            public int hashCode() {
                return super.hashCode();
            }
        });
    }

    @Nonnull
    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.conduitType.hashCode();
        result = 31 * result + ((String)NullHelper.first((Object[])new String[]{this.overrideName, ""})).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConduitDisplayMode other = (ConduitDisplayMode)obj;
        if (!this.conduitType.equals(other.conduitType)) {
            return false;
        }
        return Objects.equal((Object)this.overrideName, (Object)other.overrideName);
    }

    static {
        ConduitDisplayMode.registerDisplayMode(NEUTRAL);
        ConduitDisplayMode.registerDisplayMode(NONE);
        ConduitDisplayMode.registerDisplayMode(ALL);
    }
}

