/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.upgrades;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public interface IRule {
    @Nonnull
    public CheckResult check(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

    public static interface WithTooltip
    extends IRule {
        @Nonnull
        public ITextComponent getTooltip();
    }

    public static interface ItemType
    extends IRule {
        @Nonnull
        public ITextComponent getTooltip();

        public static interface Static
        extends ItemType,
        StaticRule {
        }
    }

    public static interface Prerequisite
    extends IRule {
        @Override
        @Nonnull
        default public CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            return this.getPrerequisite().hasUpgrade(stack, item) ? CheckResult.PASS : new CheckResult((ITextComponent)new TextComponentTranslation("enderio.darksteel.upgrades.check.prerequisite.missing", new Object[]{new TextComponentTranslation(this.getPrerequisite().getUnlocalizedName() + ".name", new Object[0])}));
        }

        @Nonnull
        public IDarkSteelUpgrade getPrerequisite();
    }

    public static interface StaticRule
    extends IRule {
    }

    public static final class CheckResult {
        @Nonnull
        public static final CheckResult PASS = new CheckResult(true);
        @Nonnull
        public static final CheckResult SILENT_FAIL = new CheckResult(false);
        private final boolean passed;
        @Nullable
        private final ITextComponent result;

        public CheckResult(ITextComponent result) {
            this.passed = false;
            this.result = result;
        }

        private CheckResult(boolean passed) {
            this.passed = passed;
            this.result = null;
        }

        public boolean passes() {
            return this.passed;
        }

        public boolean hasResult() {
            return this.result != null;
        }

        @Nonnull
        public ITextComponent getResult() {
            if (this.result != null) {
                return this.result;
            }
            throw new NullPointerException();
        }
    }
}

