/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.capacitor;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.CapacitorKeyType;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.Scaler;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface ICapacitorKey
extends IForgeRegistryEntry<ICapacitorKey> {
    default public int get(float level) {
        return (int)this.getFloat(level);
    }

    default public int get(@Nonnull ICapacitorData data) {
        return (int)this.getFloat(data);
    }

    default public int getDefault() {
        return (int)this.getDefaultFloat();
    }

    public float getFloat(float var1);

    default public float getFloat(@Nonnull ICapacitorData data) {
        return this.getFloat(data.getUnscaledValue(this));
    }

    default public float getDefaultFloat() {
        return this.getFloat(1.0f);
    }

    public int getBaseValue();

    @Nonnull
    public IModObject getOwner();

    @Nonnull
    public CapacitorKeyType getValueType();

    @Nonnull
    @Deprecated
    public String getLegacyName();

    @Nonnull
    public ResourceLocation getRegistryName();

    public void setScaler(@Nonnull Scaler var1);

    public void setBaseValue(int var1);

    public void validate() throws UnconfiguredCapKeyException;

    public static class UnconfiguredCapKeyException
    extends RuntimeException {
        private static final long serialVersionUID = 307095860368579216L;

        public UnconfiguredCapKeyException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnconfiguredCapKeyException(String message) {
            super(message);
        }
    }
}

