/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigDecimal;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryBigDecimal;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntrySerializer;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.Configuration;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ReaderHelper;

public class ConfigSerializerBigDecimal
extends ConfigEntrySerializer<ConfigEntryBigDecimal> {
    public ConfigSerializerBigDecimal() {
        super("BD");
    }

    @Override
    public void write(Configuration config, BufferedWriter writer, ConfigEntryBigDecimal entry, int indents) throws IOException {
        if (entry.getDescription() != null) {
            String range = entry.min != null ? "[" + entry.min + ";" : "(-Inf;";
            range = entry.max != null ? range + entry.max + "]" : range + "+Inf)";
            this.writeComment(writer, entry.getDescription() + " (Default: " + entry.initialValue + ", Range: " + range + ")", indents);
        }
        this.writeIndents(writer, indents);
        writer.write("+" + this.type + ":" + entry.getSerializedName() + "=" + entry.getValue() + "\n\n");
    }

    @Override
    public ConfigEntryBigDecimal read(Configuration config, ReaderHelper reader, int indents) throws IOException {
        ConfigEntryBigDecimal lnt = new ConfigEntryBigDecimal(config, null);
        reader.until('+', true);
        if (reader.eat(this.type, true) && reader.eat(':', true)) {
            String name = reader.until('=', true);
            String value = reader.getRest();
            if (value.contains("\n")) {
                value = value.substring(0, value.indexOf(10));
            }
            lnt.name = name;
            try {
                lnt.value = new BigDecimal(value);
                if (lnt.min != null) {
                    lnt.value = lnt.value.max(lnt.min);
                }
                if (lnt.max != null) {
                    lnt.value = lnt.value.min(lnt.max);
                }
            }
            catch (NumberFormatException nfe) {
                lnt.value = null;
            }
        }
        return lnt;
    }
}

