/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryBigDecimal;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryBigInt;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryBoolean;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryDouble;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryFloat;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryInt;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryLong;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntrySerializer;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryString;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryStringArray;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.Configuration;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.IConfigEntry;

public class ConfigEntryCategory
implements IConfigEntry {
    final Configuration cfg;
    String description;
    String name;
    Map<String, IConfigEntry> entries = new HashMap<String, IConfigEntry>();

    public ConfigEntryCategory(Configuration cfg) {
        this.cfg = cfg;
    }

    public ConfigEntryCategory getCategory(String name) {
        if (!(this.entries.get(name) instanceof ConfigEntryCategory)) {
            ConfigEntryCategory ces = new ConfigEntryCategory(this.cfg);
            ces.setName(name);
            this.entries.put(name, ces);
        }
        return (ConfigEntryCategory)this.entries.get(name);
    }

    public ConfigEntryString getStringEntry(String name, String defaultValue) {
        if (!(this.entries.get(name) instanceof ConfigEntryString)) {
            ConfigEntryString ces = new ConfigEntryString(this.cfg, defaultValue);
            ces.setName(name);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryString ces = (ConfigEntryString)this.entries.get(name);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryStringArray getStringArrayEntry(String name, String ... defaultValue) {
        if (!(this.entries.get(name) instanceof ConfigEntryStringArray)) {
            ConfigEntryStringArray ces = new ConfigEntryStringArray(this.cfg, defaultValue);
            ces.setName(name);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryStringArray ces = (ConfigEntryStringArray)this.entries.get(name);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryBoolean getBooleanEntry(String name, boolean defaultValue) {
        if (!(this.entries.get(name) instanceof ConfigEntryBoolean)) {
            ConfigEntryBoolean ces = new ConfigEntryBoolean(this.cfg, defaultValue);
            ces.setName(name);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryBoolean ces = (ConfigEntryBoolean)this.entries.get(name);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryInt getIntEntry(String name, int defaultValue, int min, int max) {
        if (!(this.entries.get(name) instanceof ConfigEntryInt)) {
            ConfigEntryInt ces = new ConfigEntryInt(this.cfg, defaultValue);
            ces.setName(name).setMinValue(min).setMaxValue(max);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryInt ces = (ConfigEntryInt)this.entries.get(name);
        ces.setMinValue(min).setMaxValue(max);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryBigInt getBigIntEntry(String name, BigInteger defaultValue, BigInteger min, BigInteger max) {
        if (!(this.entries.get(name) instanceof ConfigEntryBigInt)) {
            ConfigEntryBigInt ces = new ConfigEntryBigInt(this.cfg, defaultValue);
            ces.setName(name).setMinValue(min).setMaxValue(max);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryBigInt ces = (ConfigEntryBigInt)this.entries.get(name);
        ces.setMinValue(min).setMaxValue(max);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryBigDecimal getBigDecimalEntry(String name, BigDecimal defaultValue, BigDecimal min, BigDecimal max) {
        if (!(this.entries.get(name) instanceof ConfigEntryBigDecimal)) {
            ConfigEntryBigDecimal ces = new ConfigEntryBigDecimal(this.cfg, defaultValue);
            ces.setName(name).setMinValue(min).setMaxValue(max);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryBigDecimal ces = (ConfigEntryBigDecimal)this.entries.get(name);
        ces.setMinValue(min).setMaxValue(max);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryLong getLongEntry(String name, long defaultValue, long min, long max) {
        if (!(this.entries.get(name) instanceof ConfigEntryLong)) {
            ConfigEntryLong ces = new ConfigEntryLong(this.cfg, defaultValue);
            ces.setName(name).setMinValue(min).setMaxValue(max);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryLong ces = (ConfigEntryLong)this.entries.get(name);
        ces.setMinValue(min).setMaxValue(max);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryFloat getFloatEntry(String name, float defaultValue, float min, float max) {
        if (!(this.entries.get(name) instanceof ConfigEntryFloat)) {
            ConfigEntryFloat ces = new ConfigEntryFloat(this.cfg, Float.valueOf(defaultValue));
            ces.setName(name).setMinValue(min).setMaxValue(max);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryFloat ces = (ConfigEntryFloat)this.entries.get(name);
        ces.setMinValue(min).setMaxValue(max);
        ces.initialValue = Float.valueOf(defaultValue);
        return ces;
    }

    public ConfigEntryDouble getDoubleEntry(String name, double defaultValue, double min, double max) {
        if (!(this.entries.get(name) instanceof ConfigEntryDouble)) {
            ConfigEntryDouble ces = new ConfigEntryDouble(this.cfg, defaultValue);
            ces.setName(name).setMinValue(min).setMaxValue(max);
            this.entries.put(name, ces);
            return ces;
        }
        ConfigEntryDouble ces = (ConfigEntryDouble)this.entries.get(name);
        ces.setMinValue(min).setMaxValue(max);
        ces.initialValue = defaultValue;
        return ces;
    }

    public ConfigEntryCategory setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryCategory setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, IConfigEntry> getEntries() {
        return this.entries;
    }

    public IConfigEntry getEntry(String key) {
        return this.entries.get(key);
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return Configuration.SERIALIZER_CATEGORY;
    }
}

