/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;
import tk.zeitheron.solarflux.block.BlockBaseSolar;
import tk.zeitheron.solarflux.utils.PositionedStateImplementation;

@SideOnly(value=Side.CLIENT)
public class SolarPanelBakedModel
implements IBakedModel {
    public static final FaceBakery COOKER = new FaceBakery();
    public final BlockBaseSolar block;

    public SolarPanelBakedModel(BlockBaseSolar spb) {
        this.block = spb;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing sideIn, long rand) {
        EnumFacing[] sides;
        EnumFacing[] enumFacingArray;
        if (!(state instanceof PositionedStateImplementation)) {
            return Collections.emptyList();
        }
        PositionedStateImplementation pstate = (PositionedStateImplementation)state;
        IBlockAccess world = pstate.getWorld();
        BlockPos pos = pstate.getPos();
        boolean ctn = this.block.getPanelData().hasConnectedTextures();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (sideIn == null) {
            enumFacingArray = EnumFacing.field_82609_l;
        } else {
            EnumFacing[] enumFacingArray2 = new EnumFacing[1];
            enumFacingArray = enumFacingArray2;
            enumFacingArray2[0] = sideIn;
        }
        for (EnumFacing side : sides = enumFacingArray) {
            if (side == null) continue;
            TextureAtlasSprite top = this.t_top();
            TextureAtlasSprite base = this.t_base();
            float h = this.block.getPanelData().getHeight() * 16.0f;
            quads.add(COOKER.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, h, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, side.func_176740_k() == EnumFacing.Axis.Y ? 0.0f : 16.0f - h, 16.0f, 16.0f}, 4)), side == EnumFacing.UP ? top : base, side, ModelRotation.X0_Y0, null, true, true));
            if (world == null || pos == null) {
                return quads;
            }
            boolean west = false;
            boolean east = false;
            boolean north = false;
            boolean south = false;
            west = world.func_180495_p(pos.func_177976_e()).func_177230_c() != this.block || !ctn;
            if (west) {
                float[] fArray;
                Vector3f vector3f = new Vector3f(0.0f, h, 1.0f);
                Vector3f vector3f2 = new Vector3f(1.0f, h + 0.25f, 15.0f);
                if (side != EnumFacing.UP) {
                    float[] fArray2 = new float[4];
                    fArray2[0] = 0.0f;
                    fArray2[1] = 0.0f;
                    fArray2[2] = 16.0f;
                    fArray = fArray2;
                    fArray2[3] = 1.0f;
                } else {
                    float[] fArray3 = new float[4];
                    fArray3[0] = 0.0f;
                    fArray3[1] = 0.0f;
                    fArray3[2] = 1.0f;
                    fArray = fArray3;
                    fArray3[3] = 16.0f;
                }
                quads.add(COOKER.func_178414_a(vector3f, vector3f2, new BlockPartFace(null, 0, "#0", new BlockFaceUV(fArray, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
            }
            if (east = world.func_180495_p(pos.func_177974_f()).func_177230_c() != this.block || !ctn) {
                float[] fArray;
                Vector3f vector3f = new Vector3f(15.0f, h, 1.0f);
                Vector3f vector3f3 = new Vector3f(16.0f, h + 0.25f, 15.0f);
                if (side != EnumFacing.UP) {
                    float[] fArray4 = new float[4];
                    fArray4[0] = 0.0f;
                    fArray4[1] = 0.0f;
                    fArray4[2] = 16.0f;
                    fArray = fArray4;
                    fArray4[3] = 1.0f;
                } else {
                    float[] fArray5 = new float[4];
                    fArray5[0] = 15.0f;
                    fArray5[1] = 0.0f;
                    fArray5[2] = 16.0f;
                    fArray = fArray5;
                    fArray5[3] = 16.0f;
                }
                quads.add(COOKER.func_178414_a(vector3f, vector3f3, new BlockPartFace(null, 0, "#0", new BlockFaceUV(fArray, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
            }
            if (north = world.func_180495_p(pos.func_177978_c()).func_177230_c() != this.block || !ctn) {
                quads.add(COOKER.func_178414_a(new Vector3f(1.0f, h, 0.0f), new Vector3f(15.0f, h + 0.25f, 1.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
            }
            if (south = world.func_180495_p(pos.func_177968_d()).func_177230_c() != this.block || !ctn) {
                quads.add(COOKER.func_178414_a(new Vector3f(1.0f, h, 15.0f), new Vector3f(15.0f, h + 0.25f, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
            }
            if (west || north || world.func_180495_p(pos.func_177976_e().func_177978_c()).func_177230_c() != this.block || !ctn) {
                quads.add(COOKER.func_178414_a(new Vector3f(0.0f, h, 0.0f), new Vector3f(1.0f, h + 0.25f, 1.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 1.0f, 1.0f}, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
            }
            if (east || north || world.func_180495_p(pos.func_177974_f().func_177978_c()).func_177230_c() != this.block || !ctn) {
                quads.add(COOKER.func_178414_a(new Vector3f(15.0f, h, 0.0f), new Vector3f(16.0f, h + 0.25f, 1.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
            }
            if (south || east || world.func_180495_p(pos.func_177968_d().func_177974_f()).func_177230_c() != this.block || !ctn) {
                quads.add(COOKER.func_178414_a(new Vector3f(15.0f, h, 15.0f), new Vector3f(16.0f, h + 0.25f, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 15.0f, 16.0f, 16.0f}, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
            }
            if (!west && !south && world.func_180495_p(pos.func_177976_e().func_177968_d()).func_177230_c() == this.block && ctn) continue;
            quads.add(COOKER.func_178414_a(new Vector3f(0.0f, h, 15.0f), new Vector3f(1.0f, h + 0.25f, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 15.0f, 1.0f, 16.0f}, 4)), base, side, ModelRotation.X0_Y0, null, true, true));
        }
        return quads;
    }

    public ItemCameraTransforms func_177552_f() {
        return new ItemCameraTransforms(this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND), this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND), this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND), this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND), this.getTransform(ItemCameraTransforms.TransformType.HEAD), this.getTransform(ItemCameraTransforms.TransformType.GUI), this.getTransform(ItemCameraTransforms.TransformType.GROUND), this.getTransform(ItemCameraTransforms.TransformType.FIXED));
    }

    public ItemTransformVec3f getTransform(ItemCameraTransforms.TransformType type) {
        switch (type) {
            case GUI: {
                return new ItemTransformVec3f(new Vector3f(30.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
            }
        }
        return ItemTransformVec3f.field_178366_a;
    }

    public TextureAtlasSprite func_177554_e() {
        return ThreadLocalRandom.current().nextInt(5) > 0 ? this.t_base() : this.t_top();
    }

    public TextureAtlasSprite t_base() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(this.block.getRegistryName().func_110624_b() + ":blocks/" + this.block.getRegistryName().func_110623_a() + "_base");
    }

    public TextureAtlasSprite t_top() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(this.block.getRegistryName().func_110624_b() + ":blocks/" + this.block.getRegistryName().func_110623_a() + "_top");
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

