/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.world.expand;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.util.IAxisAlignedBB;
import crafttweaker.api.util.IRandom;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.util.MCRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenMethodStatic;

@ZenExpansion(value="crafttweaker.world.IWorld")
@ZenRegister
public class ExpandWorld {
    @ZenMethodStatic
    public static IWorld getFromID(int id) {
        return CraftTweakerMC.getWorldByID(id);
    }

    @ZenMethod
    public static boolean extinguishFire(IWorld world, IPlayer player, IBlockPos pos, IFacing side) {
        return CraftTweakerMC.getWorld(world).func_175719_a(CraftTweakerMC.getPlayer(player), CraftTweakerMC.getBlockPos(pos), CraftTweakerMC.getFacing(side));
    }

    @ZenMethod
    public static boolean isSpawnChunk(IWorld world, int x, int z) {
        return CraftTweakerMC.getWorld(world).func_72916_c(x, z);
    }

    @ZenMethod
    @ZenGetter(value="seaLevel")
    public static int getSeaLevel(IWorld world) {
        return CraftTweakerMC.getWorld(world).func_181545_F();
    }

    @ZenMethod
    public static IEntity createLightningBolt(IWorld world, double x, double y, double z, @Optional boolean effectOnly) {
        return CraftTweakerMC.getIEntity((Entity)new EntityLightningBolt(CraftTweakerMC.getWorld(world), x, y, z, effectOnly));
    }

    @ZenMethod
    public static boolean addWeatherEffect(IWorld world, IEntity entity) {
        return CraftTweakerMC.getWorld(world).func_72942_c(CraftTweakerMC.getEntity(entity));
    }

    @ZenMethod
    public static IEntity summonLightningBolt(IWorld world, double x, double y, double z, @Optional boolean effectOnly) {
        EntityLightningBolt bolt = new EntityLightningBolt(CraftTweakerMC.getWorld(world), x, y, z, effectOnly);
        CraftTweakerMC.getWorld(world).func_72942_c((Entity)bolt);
        return CraftTweakerMC.getIEntity((Entity)bolt);
    }

    @ZenMethod
    public static IEntity[] getEntitiesWithinAABB(IWorld world, IAxisAlignedBB aabb) {
        return (IEntity[])CraftTweakerMC.getWorld(world).func_72872_a(Entity.class, CraftTweakerMC.getAxisAlignedBB(aabb)).stream().map(CraftTweakerMC::getIEntity).toArray(IEntity[]::new);
    }

    @ZenMethod
    public static IEntity[] getEntitiesWithinAABBExcludingEntity(IWorld world, IAxisAlignedBB aabb, IEntity entity) {
        return (IEntity[])CraftTweakerMC.getWorld(world).func_72839_b(CraftTweakerMC.getEntity(entity), CraftTweakerMC.getAxisAlignedBB(aabb)).stream().map(CraftTweakerMC::getIEntity).toArray(IEntity[]::new);
    }

    @ZenMethod
    public static IEntity findNearestEntityWithinAABB(IWorld world, IAxisAlignedBB aabb, IEntity closestTo) {
        return CraftTweakerMC.getIEntity(CraftTweakerMC.getWorld(world).func_72857_a(Entity.class, CraftTweakerMC.getAxisAlignedBB(aabb), CraftTweakerMC.getEntity(closestTo)));
    }

    @ZenGetter(value="random")
    @ZenMethod
    public static IRandom getRandom(IWorld world) {
        return new MCRandom(CraftTweakerMC.getWorld((IWorld)world).field_73012_v);
    }

    @ZenMethod
    public static boolean isBlockLoaded(IWorld world, IBlockPos pos) {
        return CraftTweakerMC.getWorld(world).func_175667_e(CraftTweakerMC.getBlockPos(pos));
    }
}

