/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.game;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.game.IGame;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.world.IBiome;
import crafttweaker.mc1120.actions.ActionSetTranslation;
import crafttweaker.mc1120.brackets.BracketHandlerEnchantments;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.brackets.BracketHandlerLiquid;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.entity.MCEntityDefinition;
import crafttweaker.mc1120.item.MCItemDefinition;
import crafttweaker.mc1120.liquid.MCLiquidDefinition;
import crafttweaker.mc1120.potions.MCPotion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MCGame
implements IGame {
    public static final MCGame INSTANCE = new MCGame();
    private static final Map<String, String> TRANSLATIONS = LanguageMap.field_74817_a.field_74816_c;
    private static final List<IEntityDefinition> ENTITY_DEFINITIONS = new ArrayList<IEntityDefinition>();
    public static final List<IAction> TRANSLATION_ACTIONS = new ArrayList<IAction>();

    private MCGame() {
    }

    @Override
    public List<IItemDefinition> getItems() {
        return BracketHandlerItem.getItemNames().keySet().stream().map(item -> new MCItemDefinition((String)item, BracketHandlerItem.getItemNames().get(item))).collect(Collectors.toList());
    }

    @Override
    public List<IBlockDefinition> getBlocks() {
        return Block.field_149771_c.func_148742_b().stream().map(block -> CraftTweakerMC.getBlockDefinition((Block)Block.field_149771_c.func_82594_a(block))).collect(Collectors.toList());
    }

    @Override
    public List<ILiquidDefinition> getLiquids() {
        return FluidRegistry.getRegisteredFluids().entrySet().stream().map(entry -> new MCLiquidDefinition((Fluid)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public ILiquidStack getLiquid(String name) {
        return BracketHandlerLiquid.getLiquid(name);
    }

    @Override
    public List<IBiome> getBiomes() {
        ArrayList<IBiome> result = new ArrayList<IBiome>();
        for (IBiome biome : CraftTweakerMC.biomes) {
            if (biome == null) continue;
            result.add(biome);
        }
        return result;
    }

    @Override
    public List<IPotion> getPotions() {
        ArrayList<IPotion> potions = new ArrayList<IPotion>();
        BracketHandlerPotion.getPotionNames().forEach((s, potion) -> potions.add(new MCPotion((Potion)potion)));
        return potions;
    }

    @Override
    public List<IEntityDefinition> getEntities() {
        if (ENTITY_DEFINITIONS.isEmpty()) {
            ForgeRegistries.ENTITIES.forEach(entry -> ENTITY_DEFINITIONS.add(new MCEntityDefinition((EntityEntry)entry)));
        }
        return ENTITY_DEFINITIONS;
    }

    @Override
    public IEntityDefinition getEntity(String entityName) {
        for (IEntityDefinition ent2 : this.getEntities()) {
            if (!ent2.getName().equalsIgnoreCase(entityName)) continue;
            return ent2;
        }
        boolean needsReloading = false;
        for (ResourceLocation res : ForgeRegistries.ENTITIES.getKeys()) {
            if (!res.func_110623_a().equalsIgnoreCase(entityName)) continue;
            needsReloading = true;
            break;
        }
        if (needsReloading) {
            ENTITY_DEFINITIONS.clear();
            ForgeRegistries.ENTITIES.forEach(entry -> ENTITY_DEFINITIONS.add(new MCEntityDefinition((EntityEntry)entry)));
        }
        return this.getEntities().stream().filter(ent -> ent.getName().equals(entityName)).findFirst().orElse(null);
    }

    @Override
    public List<IEnchantmentDefinition> getEnchantments() {
        return new ArrayList<IEnchantmentDefinition>(BracketHandlerEnchantments.enchantments.values());
    }

    @Override
    public void setLocalization(String key, String value) {
        ActionSetTranslation action = new ActionSetTranslation(null, key, value);
        TRANSLATION_ACTIONS.add(action);
        CraftTweakerAPI.apply(action);
    }

    @Override
    public void setLocalization(String lang, String key, String value) {
        ActionSetTranslation action = new ActionSetTranslation(lang, key, value);
        TRANSLATION_ACTIONS.add(action);
        CraftTweakerAPI.apply(action);
    }

    @Override
    public String localize(String key) {
        return LanguageMap.field_74817_a.func_74805_b(key);
    }

    @Override
    public String localize(String key, String lang) {
        return this.localize(key);
    }

    public static Map<String, String> getTRANSLATIONS() {
        return TRANSLATIONS;
    }
}

